/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.HTTPServer;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PrometheusReporter
extends MetricsReporter {
    private static final Logger LOG = LogManager.getLogger(PrometheusReporter.class);
    private HTTPServer httpServer;
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;

    public PrometheusReporter(HoodieWriteConfig config, MetricRegistry registry) {
        int serverPort = config.getPrometheusPort();
        this.collectorRegistry = new CollectorRegistry();
        this.metricExports = new DropwizardExports(registry);
        this.metricExports.register(this.collectorRegistry);
        try {
            this.httpServer = new HTTPServer(new InetSocketAddress(serverPort), this.collectorRegistry);
        }
        catch (Exception e) {
            String msg = "Could not start PrometheusReporter HTTP server on port " + serverPort;
            LOG.error((Object)msg, (Throwable)e);
            throw new HoodieException(msg, e);
        }
    }

    @Override
    public void start() {
    }

    @Override
    public void report() {
    }

    @Override
    public Closeable getReporter() {
        return null;
    }

    @Override
    public void stop() {
        this.collectorRegistry.unregister((Collector)this.metricExports);
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
    }
}

