/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.ReplaceArchivalHelper;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.block.HoodieAvroDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCommitException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.MarkerFiles;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieTimelineArchiveLog<T extends HoodieAvroPayload, I, K, O> {
    private static final Logger LOG = LogManager.getLogger(HoodieTimelineArchiveLog.class);
    private final Path archiveFilePath;
    private final HoodieWriteConfig config;
    private HoodieLogFormat.Writer writer;
    private final int maxInstantsToKeep;
    private final int minInstantsToKeep;
    private final HoodieTable<T, I, K, O> table;
    private final HoodieTableMetaClient metaClient;

    public HoodieTimelineArchiveLog(HoodieWriteConfig config, HoodieTable<T, I, K, O> table) {
        this.config = config;
        this.table = table;
        this.metaClient = table.getMetaClient();
        this.archiveFilePath = HoodieArchivedTimeline.getArchiveLogPath(this.metaClient.getArchivePath());
        this.maxInstantsToKeep = config.getMaxCommitsToKeep();
        this.minInstantsToKeep = config.getMinCommitsToKeep();
    }

    private HoodieLogFormat.Writer openWriter() {
        try {
            if (this.writer == null) {
                return HoodieLogFormat.newWriterBuilder().onParentPath(this.archiveFilePath.getParent()).withFileId(this.archiveFilePath.getName()).withFileExtension(".archive").withFs(this.metaClient.getFs()).overBaseCommit("").build();
            }
            return this.writer;
        }
        catch (IOException e) {
            throw new HoodieException("Unable to initialize HoodieLogFormat writer", e);
        }
    }

    private void close() {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new HoodieException("Unable to close HoodieLogFormat writer", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean archiveIfRequired(HoodieEngineContext context) throws IOException {
        try {
            List<HoodieInstant> instantsToArchive = this.getInstantsToArchive().collect(Collectors.toList());
            boolean success = true;
            if (!instantsToArchive.isEmpty()) {
                this.writer = this.openWriter();
                LOG.info((Object)("Archiving instants " + instantsToArchive));
                this.archive(context, instantsToArchive);
                LOG.info((Object)("Deleting archived instants " + instantsToArchive));
                success = this.deleteArchivedInstants(instantsToArchive);
            } else {
                LOG.info((Object)"No Instants to archive");
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.close();
        }
    }

    private Stream<HoodieInstant> getCleanInstantsToArchive() {
        HoodieTimeline cleanAndRollbackTimeline = this.table.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet("clean", "rollback")).filterCompletedInstants();
        return cleanAndRollbackTimeline.getInstants().collect(Collectors.groupingBy(HoodieInstant::getAction)).values().stream().map(hoodieInstants -> {
            if (hoodieInstants.size() > this.maxInstantsToKeep) {
                return hoodieInstants.subList(0, hoodieInstants.size() - this.minInstantsToKeep);
            }
            return new ArrayList();
        }).flatMap(Collection::stream);
    }

    private Stream<HoodieInstant> getCommitInstantsToArchive() {
        HoodieTimeline commitTimeline = this.table.getCompletedCommitsTimeline();
        Option<HoodieInstant> oldestPendingCompactionInstant = this.table.getActiveTimeline().filterPendingCompactionTimeline().firstInstant();
        Option<HoodieInstant> firstSavepoint = this.table.getCompletedSavepointTimeline().firstInstant();
        if (!commitTimeline.empty() && commitTimeline.countInstants() > this.maxInstantsToKeep) {
            return commitTimeline.getInstants().filter(s -> !firstSavepoint.isPresent() || !HoodieTimeline.compareTimestamps(((HoodieInstant)firstSavepoint.get()).getTimestamp(), HoodieTimeline.LESSER_THAN_OR_EQUALS, s.getTimestamp())).filter(s -> oldestPendingCompactionInstant.map(instant -> HoodieTimeline.compareTimestamps(instant.getTimestamp(), HoodieTimeline.GREATER_THAN, s.getTimestamp())).orElse(true)).limit(commitTimeline.countInstants() - this.minInstantsToKeep);
        }
        return Stream.empty();
    }

    private Stream<HoodieInstant> getInstantsToArchive() {
        Stream<HoodieInstant> instants = Stream.concat(this.getCleanInstantsToArchive(), this.getCommitInstantsToArchive());
        HoodieActiveTimeline rawActiveTimeline = new HoodieActiveTimeline(this.metaClient, false);
        Map<Pair, List<HoodieInstant>> groupByTsAction = rawActiveTimeline.getInstants().collect(Collectors.groupingBy(i -> Pair.of(i.getTimestamp(), HoodieInstant.getComparableAction(i.getAction()))));
        if (this.config.useFileListingMetadata()) {
            try (HoodieTableMetadata tableMetadata = HoodieTableMetadata.create(this.table.getContext(), this.config.getMetadataConfig(), this.config.getBasePath(), "/tmp/view_map/");){
                Option<String> lastSyncedInstantTime = tableMetadata.getSyncedInstantTime();
                if (lastSyncedInstantTime.isPresent()) {
                    LOG.info((Object)("Limiting archiving of instants to last synced instant on metadata table at " + lastSyncedInstantTime.get()));
                    instants = instants.filter(i -> HoodieTimeline.compareTimestamps(i.getTimestamp(), HoodieTimeline.LESSER_THAN, (String)lastSyncedInstantTime.get()));
                } else {
                    LOG.info((Object)"Not archiving as there is no instants yet on the metadata table");
                    instants = Stream.empty();
                }
            }
            catch (Exception e) {
                throw new HoodieException("Error limiting instant archival based on metadata table", e);
            }
        }
        return instants.flatMap(hoodieInstant -> ((List)groupByTsAction.get(Pair.of(hoodieInstant.getTimestamp(), HoodieInstant.getComparableAction(hoodieInstant.getAction())))).stream());
    }

    private boolean deleteArchivedInstants(List<HoodieInstant> archivedInstants) throws IOException {
        LOG.info((Object)("Deleting instants " + archivedInstants));
        boolean success = true;
        for (HoodieInstant archivedInstant : archivedInstants) {
            Path commitFile = new Path(this.metaClient.getMetaPath(), archivedInstant.getFileName());
            try {
                if (!this.metaClient.getFs().exists(commitFile)) continue;
                success &= this.metaClient.getFs().delete(commitFile, false);
                LOG.info((Object)("Archived and deleted instant file " + commitFile));
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to delete archived instant " + archivedInstant, e);
            }
        }
        Option<HoodieInstant> latestCommitted = Option.fromJavaOptional(archivedInstants.stream().filter(i -> i.isCompleted() && (i.getAction().equals("commit") || i.getAction().equals("deltacommit"))).max(Comparator.comparing(HoodieInstant::getTimestamp)));
        LOG.info((Object)("Latest Committed Instant=" + latestCommitted));
        if (latestCommitted.isPresent()) {
            success &= this.deleteAllInstantsOlderorEqualsInAuxMetaFolder(latestCommitted.get());
        }
        return success;
    }

    private boolean deleteAllInstantsOlderorEqualsInAuxMetaFolder(HoodieInstant thresholdInstant) throws IOException {
        List<HoodieInstant> instants = null;
        boolean success = true;
        try {
            instants = this.metaClient.scanHoodieInstantsFromFileSystem(new Path(this.metaClient.getMetaAuxiliaryPath()), HoodieActiveTimeline.VALID_EXTENSIONS_IN_ACTIVE_TIMELINE, false);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("Aux path not found. Skipping: " + this.metaClient.getMetaAuxiliaryPath()));
            return success;
        }
        List instantsToBeDeleted = instants.stream().filter(instant1 -> HoodieTimeline.compareTimestamps(instant1.getTimestamp(), HoodieTimeline.LESSER_THAN_OR_EQUALS, thresholdInstant.getTimestamp())).collect(Collectors.toList());
        for (HoodieInstant deleteInstant : instantsToBeDeleted) {
            LOG.info((Object)("Deleting instant " + deleteInstant + " in auxiliary meta path " + this.metaClient.getMetaAuxiliaryPath()));
            Path metaFile = new Path(this.metaClient.getMetaAuxiliaryPath(), deleteInstant.getFileName());
            if (!this.metaClient.getFs().exists(metaFile)) continue;
            success &= this.metaClient.getFs().delete(metaFile, false);
            LOG.info((Object)("Deleted instant file in auxiliary metapath : " + metaFile));
        }
        return success;
    }

    public void archive(HoodieEngineContext context, List<HoodieInstant> instants) throws HoodieCommitException {
        try {
            HoodieTimeline commitTimeline = this.metaClient.getActiveTimeline().getAllCommitsTimeline().filterCompletedInstants();
            Schema wrapperSchema = HoodieArchivedMetaEntry.getClassSchema();
            LOG.info((Object)("Wrapper schema " + wrapperSchema.toString()));
            ArrayList<IndexedRecord> records = new ArrayList<IndexedRecord>();
            for (HoodieInstant hoodieInstant : instants) {
                boolean deleteSuccess = this.deleteReplacedFileGroups(context, hoodieInstant);
                if (!deleteSuccess) {
                    LOG.warn((Object)("Unable to delete file(s) for " + hoodieInstant.getFileName() + ", replaced files possibly deleted by cleaner"));
                }
                try {
                    this.deleteAnyLeftOverMarkerFiles(context, hoodieInstant);
                    records.add(this.convertToAvroRecord(commitTimeline, hoodieInstant));
                    if (records.size() < this.config.getCommitArchivalBatchSize()) continue;
                    this.writeToFile(wrapperSchema, records);
                }
                catch (Exception e) {
                    LOG.error((Object)("Failed to archive commits, .commit file: " + hoodieInstant.getFileName()), (Throwable)e);
                    if (!this.config.isFailOnTimelineArchivingEnabled()) continue;
                    throw e;
                }
            }
            this.writeToFile(wrapperSchema, records);
        }
        catch (Exception e) {
            throw new HoodieCommitException("Failed to archive commits", e);
        }
    }

    private void deleteAnyLeftOverMarkerFiles(HoodieEngineContext context, HoodieInstant instant) {
        MarkerFiles markerFiles = new MarkerFiles(this.table, instant.getTimestamp());
        if (markerFiles.deleteMarkerDir(context, this.config.getMarkersDeleteParallelism())) {
            LOG.info((Object)("Cleaned up left over marker directory for instant :" + instant));
        }
    }

    private boolean deleteReplacedFileGroups(HoodieEngineContext context, HoodieInstant instant) {
        if (!instant.isCompleted() || !"replacecommit".equals(instant.getAction())) {
            return true;
        }
        TableFileSystemView fileSystemView = this.table.getFileSystemView();
        List<String> replacedPartitions = this.getReplacedPartitions(instant);
        return ReplaceArchivalHelper.deleteReplacedFileGroups(context, this.metaClient, fileSystemView, instant, replacedPartitions);
    }

    private List<String> getReplacedPartitions(HoodieInstant instant) {
        try {
            HoodieReplaceCommitMetadata metadata = HoodieReplaceCommitMetadata.fromBytes(this.metaClient.getActiveTimeline().getInstantDetails(instant).get(), HoodieReplaceCommitMetadata.class);
            return new ArrayList<String>(metadata.getPartitionToReplaceFileIds().keySet());
        }
        catch (IOException e) {
            throw new HoodieCommitException("Failed to archive because cannot delete replace files", e);
        }
    }

    private void writeToFile(Schema wrapperSchema, List<IndexedRecord> records) throws Exception {
        if (records.size() > 0) {
            HashMap<HoodieLogBlock.HeaderMetadataType, String> header = new HashMap<HoodieLogBlock.HeaderMetadataType, String>();
            header.put(HoodieLogBlock.HeaderMetadataType.SCHEMA, wrapperSchema.toString());
            HoodieAvroDataBlock block = new HoodieAvroDataBlock(records, header);
            this.writer.appendBlock(block);
            records.clear();
        }
    }

    private IndexedRecord convertToAvroRecord(HoodieTimeline commitTimeline, HoodieInstant hoodieInstant) throws IOException {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.getTimestamp());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(this.metaClient, hoodieInstant));
                } else {
                    archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(this.metaClient, hoodieInstant));
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": 
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = org.apache.hudi.common.model.HoodieCommitMetadata.fromBytes(commitTimeline.getInstantDetails(hoodieInstant).get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata(HoodieTimelineArchiveLog.convertCommitMetadata(commitMetadata));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "replacecommit": {
                HoodieReplaceCommitMetadata replaceCommitMetadata = HoodieReplaceCommitMetadata.fromBytes(commitTimeline.getInstantDetails(hoodieInstant).get(), HoodieReplaceCommitMetadata.class);
                archivedMetaWrapper.setHoodieReplaceCommitMetadata(ReplaceArchivalHelper.convertReplaceCommitMetadata(replaceCommitMetadata));
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setHoodieRollbackMetadata(TimelineMetadataUtils.deserializeAvroMetadata(commitTimeline.getInstantDetails(hoodieInstant).get(), HoodieRollbackMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata(TimelineMetadataUtils.deserializeAvroMetadata(commitTimeline.getInstantDetails(hoodieInstant).get(), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(this.metaClient, hoodieInstant.getTimestamp());
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    public static HoodieCommitMetadata convertCommitMetadata(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        HoodieCommitMetadata avroMetaData = (HoodieCommitMetadata)((Object)mapper.convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class));
        avroMetaData.getExtraMetadata().put("ROLLING_STAT", "");
        return avroMetaData;
    }
}

