/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.action.commit.AbstractWriteHelper;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkWriteHelper<T extends HoodieRecordPayload, R>
extends AbstractWriteHelper<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>, R> {
    private SparkWriteHelper() {
    }

    public static SparkWriteHelper newInstance() {
        return WriteHelperHolder.SPARK_WRITE_HELPER;
    }

    @Override
    public JavaRDD<HoodieRecord<T>> deduplicateRecords(JavaRDD<HoodieRecord<T>> records, HoodieIndex<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> index, int parallelism) {
        boolean isIndexingGlobal = index.isGlobal();
        return records.mapToPair((PairFunction & Serializable)record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return new Tuple2(key, record);
        }).reduceByKey((Function2 & Serializable)(rec1, rec2) -> {
            Object reducedData = rec1.getData().preCombine(rec2.getData());
            HoodieKey reducedKey = rec1.getData().equals(reducedData) ? rec1.getKey() : rec2.getKey();
            return new HoodieRecord(reducedKey, reducedData);
        }, parallelism).map(Tuple2::_2);
    }

    private static class WriteHelperHolder {
        private static final SparkWriteHelper SPARK_WRITE_HELPER = new SparkWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

