/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieCompactionException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.BaseScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.compact.HoodieSparkMergeOnReadTableCompactor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.api.java.JavaRDD;

public class SparkScheduleCompactionActionExecutor<T extends HoodieRecordPayload>
extends BaseScheduleCompactionActionExecutor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    private static final Logger LOG = LogManager.getLogger(SparkScheduleCompactionActionExecutor.class);

    public SparkScheduleCompactionActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime, extraMetadata);
    }

    @Override
    protected HoodieCompactionPlan scheduleCompaction() {
        LOG.info((Object)("Checking if compaction needs to be run on " + this.config.getBasePath()));
        Option<HoodieInstant> lastCompaction = this.table.getActiveTimeline().getCommitTimeline().filterCompletedInstants().lastInstant();
        String lastCompactionTs = "0";
        if (lastCompaction.isPresent()) {
            lastCompactionTs = lastCompaction.get().getTimestamp();
        }
        int deltaCommitsSinceLastCompaction = this.table.getActiveTimeline().getDeltaCommitTimeline().findInstantsAfter(lastCompactionTs, Integer.MAX_VALUE).countInstants();
        if (this.config.getInlineCompactDeltaCommitMax() > deltaCommitsSinceLastCompaction) {
            LOG.info((Object)("Not scheduling compaction as only " + deltaCommitsSinceLastCompaction + " delta commits was found since last compaction " + lastCompactionTs + ". Waiting for " + this.config.getInlineCompactDeltaCommitMax()));
            return new HoodieCompactionPlan();
        }
        LOG.info((Object)("Generating compaction plan for merge on read table " + this.config.getBasePath()));
        HoodieSparkMergeOnReadTableCompactor compactor = new HoodieSparkMergeOnReadTableCompactor();
        try {
            SyncableFileSystemView fileSystemView = (SyncableFileSystemView)this.table.getSliceView();
            Set<HoodieFileGroupId> fgInPendingCompactionAndClustering = fileSystemView.getPendingCompactionOperations().map(instantTimeOpPair -> ((CompactionOperation)instantTimeOpPair.getValue()).getFileGroupId()).collect(Collectors.toSet());
            fgInPendingCompactionAndClustering.addAll(fileSystemView.getFileGroupsInPendingClustering().map(Pair::getLeft).collect(Collectors.toSet()));
            return compactor.generateCompactionPlan(this.context, this.table, this.config, this.instantTime, fgInPendingCompactionAndClustering);
        }
        catch (IOException e) {
            throw new HoodieCompactionException("Could not schedule compaction " + this.config.getBasePath(), e);
        }
    }
}

