/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.SparkBulkInsertHelper;
import org.apache.hudi.table.action.deltacommit.AbstractSparkDeltaCommitActionExecutor;
import org.apache.spark.api.java.JavaRDD;

public class SparkBulkInsertPreppedDeltaCommitActionExecutor<T extends HoodieRecordPayload<T>>
extends AbstractSparkDeltaCommitActionExecutor<T> {
    private final JavaRDD<HoodieRecord<T>> preppedInputRecordRdd;
    private final Option<BulkInsertPartitioner<T>> bulkInsertPartitioner;

    public SparkBulkInsertPreppedDeltaCommitActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, JavaRDD<HoodieRecord<T>> preppedInputRecordRdd, Option<BulkInsertPartitioner<T>> bulkInsertPartitioner) {
        super(context, config, table, instantTime, WriteOperationType.BULK_INSERT);
        this.preppedInputRecordRdd = preppedInputRecordRdd;
        this.bulkInsertPartitioner = bulkInsertPartitioner;
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> execute() {
        try {
            return SparkBulkInsertHelper.newInstance().bulkInsert(this.preppedInputRecordRdd, this.instantTime, this.table, this.config, this, false, this.bulkInsertPartitioner);
        }
        catch (Throwable e) {
            if (e instanceof HoodieInsertException) {
                throw e;
            }
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

