/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.BaseRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.SparkMergeOnReadRollbackActionExecutor;
import org.apache.spark.api.java.JavaRDD;

public class SparkMergeOnReadRestoreActionExecutor<T extends HoodieRecordPayload>
extends BaseRestoreActionExecutor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    public SparkMergeOnReadRestoreActionExecutor(HoodieSparkEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, String restoreInstantTime) {
        super(context, config, table, instantTime, restoreInstantTime);
    }

    @Override
    protected HoodieRollbackMetadata rollbackInstant(HoodieInstant instantToRollback) {
        this.table.getMetaClient().reloadActiveTimeline();
        SparkMergeOnReadRollbackActionExecutor rollbackActionExecutor = new SparkMergeOnReadRollbackActionExecutor(this.context, this.config, this.table, HoodieActiveTimeline.createNewInstantTime(), instantToRollback, true, true, false);
        switch (instantToRollback.getAction()) {
            case "commit": 
            case "deltacommit": 
            case "compaction": 
            case "replacecommit": {
                return rollbackActionExecutor.execute();
            }
        }
        throw new IllegalArgumentException("invalid action name " + instantToRollback.getAction());
    }
}

