/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.io.IOException;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.HoodieRollbackStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.rollback.BaseMergeOnReadRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackActionExecutor;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackHelper;
import org.apache.hudi.table.action.rollback.ListingBasedRollbackRequest;
import org.apache.hudi.table.action.rollback.RollbackUtils;
import org.apache.hudi.table.action.rollback.SparkMarkerBasedRollbackStrategy;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;

public class SparkMergeOnReadRollbackActionExecutor<T extends HoodieRecordPayload>
extends BaseMergeOnReadRollbackActionExecutor<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> {
    public SparkMergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants) {
        super(context, config, table, instantTime, commitInstant, deleteInstants);
    }

    public SparkMergeOnReadRollbackActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, JavaRDD<HoodieRecord<T>>, JavaRDD<HoodieKey>, JavaRDD<WriteStatus>> table, String instantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipTimelinePublish, boolean useMarkerBasedStrategy) {
        super(context, config, table, instantTime, commitInstant, deleteInstants, skipTimelinePublish, useMarkerBasedStrategy);
    }

    @Override
    protected BaseRollbackActionExecutor.RollbackStrategy getRollbackStrategy() {
        if (this.useMarkerBasedStrategy) {
            return new SparkMarkerBasedRollbackStrategy(this.table, this.context, this.config, this.instantTime);
        }
        return this::executeRollbackUsingFileListing;
    }

    @Override
    protected List<HoodieRollbackStat> executeRollbackUsingFileListing(HoodieInstant resolvedInstant) {
        List<ListingBasedRollbackRequest> rollbackRequests;
        JavaSparkContext jsc = HoodieSparkEngineContext.getSparkContext(this.context);
        try {
            rollbackRequests = RollbackUtils.generateRollbackRequestsUsingFileListingMOR(resolvedInstant, this.table, this.context);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error generating rollback requests by file listing.", e);
        }
        return new ListingBasedRollbackHelper(this.table.getMetaClient(), this.config).performRollback(this.context, resolvedInstant, rollbackRequests);
    }
}

