/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities;

import io.hops.hudi.com.beust.jcommander.JCommander;
import io.hops.hudi.com.beust.jcommander.Parameter;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.client.CompactionAdminClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.utilities.UtilHelpers;
import org.apache.spark.api.java.JavaSparkContext;

public class HoodieCompactionAdminTool {
    private final Config cfg;

    public HoodieCompactionAdminTool(Config cfg) {
        this.cfg = cfg;
    }

    public static void main(String[] args) throws Exception {
        Config cfg = new Config();
        JCommander cmd = new JCommander((Object)cfg, null, args);
        if (cfg.help.booleanValue() || args.length == 0) {
            cmd.usage();
            System.exit(1);
        }
        HoodieCompactionAdminTool admin = new HoodieCompactionAdminTool(cfg);
        admin.run(UtilHelpers.buildSparkContext("admin-compactor", cfg.sparkMaster, cfg.sparkMemory));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(JavaSparkContext jsc) throws Exception {
        HoodieTableMetaClient metaClient = new HoodieTableMetaClient(jsc.hadoopConfiguration(), this.cfg.basePath);
        try (CompactionAdminClient admin = new CompactionAdminClient((HoodieEngineContext)new HoodieSparkEngineContext(jsc), this.cfg.basePath);){
            FileSystem fs = FSUtils.getFs(this.cfg.basePath, jsc.hadoopConfiguration());
            if (this.cfg.outputPath != null && fs.exists(new Path(this.cfg.outputPath))) {
                throw new IllegalStateException("Output File Path already exists");
            }
            switch (this.cfg.operation) {
                case VALIDATE: {
                    List<CompactionAdminClient.ValidationOpResult> res = admin.validateCompactionPlan(metaClient, this.cfg.compactionInstantTime, this.cfg.parallelism);
                    if (this.cfg.printOutput) {
                        this.printOperationResult("Result of Validation Operation :", res);
                    }
                    this.serializeOperationResult(fs, res);
                    return;
                }
                case UNSCHEDULE_FILE: {
                    List<CompactionAdminClient.RenameOpResult> r = admin.unscheduleCompactionFileId(new HoodieFileGroupId(this.cfg.partitionPath, this.cfg.fileId), this.cfg.skipValidation, this.cfg.dryRun);
                    if (this.cfg.printOutput) {
                        System.out.println(r);
                    }
                    this.serializeOperationResult(fs, r);
                    return;
                }
                case UNSCHEDULE_PLAN: {
                    List<CompactionAdminClient.RenameOpResult> r2 = admin.unscheduleCompactionPlan(this.cfg.compactionInstantTime, this.cfg.skipValidation, this.cfg.parallelism, this.cfg.dryRun);
                    if (this.cfg.printOutput) {
                        this.printOperationResult("Result of Unscheduling Compaction Plan :", r2);
                    }
                    this.serializeOperationResult(fs, r2);
                    return;
                }
                case REPAIR: {
                    List<CompactionAdminClient.RenameOpResult> r3 = admin.repairCompaction(this.cfg.compactionInstantTime, this.cfg.parallelism, this.cfg.dryRun);
                    if (this.cfg.printOutput) {
                        this.printOperationResult("Result of Repair Operation :", r3);
                    }
                    this.serializeOperationResult(fs, r3);
                    return;
                }
                default: {
                    throw new IllegalStateException("Not yet implemented !!");
                }
            }
        }
    }

    private <T> void serializeOperationResult(FileSystem fs, T result) throws Exception {
        if (this.cfg.outputPath != null && result != null) {
            Path outputPath = new Path(this.cfg.outputPath);
            FSDataOutputStream fsout = fs.create(outputPath, true);
            ObjectOutputStream out = new ObjectOutputStream((OutputStream)fsout);
            out.writeObject(result);
            out.close();
            fsout.close();
        }
    }

    private <T> void printOperationResult(String initialLine, List<T> result) {
        System.out.println(initialLine);
        for (T r : result) {
            System.out.print(r);
        }
    }

    public static class Config
    implements Serializable {
        @Parameter(names={"--operation", "-op"}, description="Operation", required=true)
        public Operation operation = Operation.VALIDATE;
        @Parameter(names={"--base-path", "-bp"}, description="Base path for the table", required=true)
        public String basePath = null;
        @Parameter(names={"--instant-time", "-in"}, description="Compaction Instant time", required=false)
        public String compactionInstantTime = null;
        @Parameter(names={"--partition-path", "-pp"}, description="Partition Path", required=false)
        public String partitionPath = null;
        @Parameter(names={"--file-id", "-id"}, description="File Id", required=false)
        public String fileId = null;
        @Parameter(names={"--parallelism", "-pl"}, description="Parallelism for hoodie insert", required=false)
        public int parallelism = 3;
        @Parameter(names={"--spark-master", "-ms"}, description="Spark master", required=true)
        public String sparkMaster = null;
        @Parameter(names={"--spark-memory", "-sm"}, description="spark memory to use", required=true)
        public String sparkMemory = null;
        @Parameter(names={"--dry-run", "-dr"}, description="Dry Run Mode", required=false)
        public boolean dryRun = false;
        @Parameter(names={"--skip-validation", "-sv"}, description="Skip Validation", required=false)
        public boolean skipValidation = false;
        @Parameter(names={"--output-path", "-ot"}, description="Output Path", required=false)
        public String outputPath = null;
        @Parameter(names={"--print-output", "-pt"}, description="Print Output", required=false)
        public boolean printOutput = true;
        @Parameter(names={"--help", "-h"}, help=true)
        public Boolean help = false;
    }

    public static enum Operation {
        VALIDATE,
        UNSCHEDULE_PLAN,
        UNSCHEDULE_FILE,
        REPAIR;

    }
}

