/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.sources;

import java.io.Serializable;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.PublicAPIMethod;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.hudi.utilities.sources.InputBatch;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public abstract class Source<T>
implements Serializable {
    protected transient TypedProperties props;
    protected transient JavaSparkContext sparkContext;
    protected transient SparkSession sparkSession;
    private transient SchemaProvider overriddenSchemaProvider;
    private final SourceType sourceType;

    protected Source(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider) {
        this(props, sparkContext, sparkSession, schemaProvider, SourceType.AVRO);
    }

    protected Source(TypedProperties props, JavaSparkContext sparkContext, SparkSession sparkSession, SchemaProvider schemaProvider, SourceType sourceType) {
        this.props = props;
        this.sparkContext = sparkContext;
        this.sparkSession = sparkSession;
        this.overriddenSchemaProvider = schemaProvider;
        this.sourceType = sourceType;
    }

    @PublicAPIMethod(maturity=ApiMaturityLevel.STABLE)
    protected abstract InputBatch<T> fetchNewData(Option<String> var1, long var2);

    public final InputBatch<T> fetchNext(Option<String> lastCkptStr, long sourceLimit) {
        InputBatch batch = this.fetchNewData(lastCkptStr, sourceLimit);
        return this.overriddenSchemaProvider == null ? batch : new InputBatch(batch.getBatch(), batch.getCheckpointForNextBatch(), this.overriddenSchemaProvider);
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public SparkSession getSparkSession() {
        return this.sparkSession;
    }

    public static enum SourceType {
        JSON,
        AVRO,
        ROW;

    }
}

