/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.kafka010;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.kafka.common.TopicPartition;
import org.apache.spark.streaming.kafka010.ConsumerStrategies;
import org.apache.spark.streaming.kafka010.ConsumerStrategy;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.collection.Iterable;
import scala.collection.JavaConverters;
import scala.collection.Map;
import scala.runtime.AbstractFunction1;

public class JavaConsumerStrategySuite
implements Serializable {
    @Test
    public void testConsumerStrategyConstructors() {
        String topic1 = "topic1";
        Pattern pat = Pattern.compile("top.*");
        List<String> topics = Arrays.asList("topic1");
        Iterable sTopics = (Iterable)JavaConverters.collectionAsScalaIterableConverter(topics).asScala();
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic1", 1);
        List<TopicPartition> parts = Arrays.asList(tp1, tp2);
        Iterable sParts = (Iterable)JavaConverters.collectionAsScalaIterableConverter(parts).asScala();
        HashMap<String, Object> kafkaParams = new HashMap<String, Object>();
        kafkaParams.put("bootstrap.servers", "not used");
        Map sKafkaParams = (Map)JavaConverters.mapAsScalaMapConverter(kafkaParams).asScala();
        HashMap<TopicPartition, Long> offsets = new HashMap<TopicPartition, Long>();
        offsets.put(tp1, 23L);
        Map sOffsets = ((scala.collection.mutable.Map)JavaConverters.mapAsScalaMapConverter(offsets).asScala()).mapValues((Function1)new AbstractFunction1<Long, Object>(){

            public Object apply(Long x) {
                return x;
            }
        });
        ConsumerStrategy sub1 = ConsumerStrategies.Subscribe((Iterable<String>)sTopics, (Map<String, Object>)sKafkaParams, (Map<TopicPartition, Object>)sOffsets);
        ConsumerStrategy sub2 = ConsumerStrategies.Subscribe((Iterable<String>)sTopics, (Map<String, Object>)sKafkaParams);
        ConsumerStrategy sub3 = ConsumerStrategies.Subscribe(topics, kafkaParams, offsets);
        ConsumerStrategy sub4 = ConsumerStrategies.Subscribe(topics, kafkaParams);
        Assert.assertEquals((Object)sub1.executorKafkaParams().get("bootstrap.servers"), (Object)sub3.executorKafkaParams().get("bootstrap.servers"));
        ConsumerStrategy psub1 = ConsumerStrategies.SubscribePattern(pat, (Map<String, Object>)sKafkaParams, (Map<TopicPartition, Object>)sOffsets);
        ConsumerStrategy psub2 = ConsumerStrategies.SubscribePattern(pat, (Map<String, Object>)sKafkaParams);
        ConsumerStrategy psub3 = ConsumerStrategies.SubscribePattern(pat, kafkaParams, offsets);
        ConsumerStrategy psub4 = ConsumerStrategies.SubscribePattern(pat, kafkaParams);
        Assert.assertEquals((Object)psub1.executorKafkaParams().get("bootstrap.servers"), (Object)psub3.executorKafkaParams().get("bootstrap.servers"));
        ConsumerStrategy asn1 = ConsumerStrategies.Assign((Iterable<TopicPartition>)sParts, (Map<String, Object>)sKafkaParams, (Map<TopicPartition, Object>)sOffsets);
        ConsumerStrategy asn2 = ConsumerStrategies.Assign((Iterable<TopicPartition>)sParts, (Map<String, Object>)sKafkaParams);
        ConsumerStrategy asn3 = ConsumerStrategies.Assign(parts, kafkaParams, offsets);
        ConsumerStrategy asn4 = ConsumerStrategies.Assign(parts, kafkaParams);
        Assert.assertEquals((Object)asn1.executorKafkaParams().get("bootstrap.servers"), (Object)asn3.executorKafkaParams().get("bootstrap.servers"));
    }
}

