/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.services.dynamodbv2.AcquireLockOptions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClientOptions;
import com.amazonaws.services.dynamodbv2.CreateDynamoDBTableOptions;
import com.amazonaws.services.dynamodbv2.GetLockOptions;
import com.amazonaws.services.dynamodbv2.LockItem;
import com.amazonaws.services.dynamodbv2.LockItemPaginatedScanIterator;
import com.amazonaws.services.dynamodbv2.ReleaseLockOptions;
import com.amazonaws.services.dynamodbv2.SendHeartbeatOptions;
import com.amazonaws.services.dynamodbv2.SessionMonitor;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ConditionalCheckFailedException;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.LockCurrentlyUnavailableException;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import com.amazonaws.services.dynamodbv2.model.LockTableDoesNotExistException;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputExceededException;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.TableStatus;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.util.LockClientUtils;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonDynamoDBLockClient
implements Runnable,
Closeable {
    private static final Log logger = LogFactory.getLog(AmazonDynamoDBLockClient.class);
    private static final Set<TableStatus> availableStatuses;
    protected static final String SK_PATH_EXPRESSION_VARIABLE = "#sk";
    protected static final String PK_PATH_EXPRESSION_VARIABLE = "#pk";
    protected static final String NEW_RVN_VALUE_EXPRESSION_VARIABLE = ":newRvn";
    protected static final String LEASE_DURATION_PATH_VALUE_EXPRESSION_VARIABLE = "#ld";
    protected static final String LEASE_DURATION_VALUE_EXPRESSION_VARIABLE = ":ld";
    protected static final String RVN_PATH_EXPRESSION_VARIABLE = "#rvn";
    protected static final String RVN_VALUE_EXPRESSION_VARIABLE = ":rvn";
    protected static final String OWNER_NAME_PATH_EXPRESSION_VARIABLE = "#on";
    protected static final String OWNER_NAME_VALUE_EXPRESSION_VARIABLE = ":on";
    protected static final String DATA_PATH_EXPRESSION_VARIABLE = "#d";
    protected static final String DATA_VALUE_EXPRESSION_VARIABLE = ":d";
    protected static final String IS_RELEASED_PATH_EXPRESSION_VARIABLE = "#ir";
    protected static final String IS_RELEASED_VALUE_EXPRESSION_VARIABLE = ":ir";
    protected static final String ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_CONDITION;
    protected static final String ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_SK_CONDITION;
    protected static final String PK_EXISTS_AND_IS_RELEASED_CONDITION;
    protected static final String PK_EXISTS_AND_SK_EXISTS_AND_IS_RELEASED_CONDITION;
    protected static final String PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION;
    protected static final String PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION;
    protected static final String PK_EXISTS_AND_SK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
    protected static final String PK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION;
    protected static final String PK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION;
    protected static final String PK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
    protected static final String UPDATE_IS_RELEASED;
    protected static final String UPDATE_IS_RELEASED_AND_DATA;
    protected static final String UPDATE_LEASE_DURATION_AND_RVN;
    protected static final String UPDATE_LEASE_DURATION_AND_RVN_AND_REMOVE_DATA;
    protected static final String UPDATE_LEASE_DURATION_AND_RVN_AND_DATA;
    protected static final String REMOVE_IS_RELEASED_UPDATE_EXPRESSION;
    protected final AmazonDynamoDB dynamoDB;
    protected final String tableName;
    private final String partitionKeyName;
    private final Optional<String> sortKeyName;
    private final long leaseDurationInMilliseconds;
    private final long heartbeatPeriodInMilliseconds;
    private final boolean holdLockOnServiceUnavailable;
    private final String ownerName;
    private final ConcurrentHashMap<String, LockItem> locks;
    private final ConcurrentHashMap<String, Thread> sessionMonitors;
    private final Optional<Thread> backgroundThread;
    private final Function<String, ThreadFactory> namedThreadCreator;
    private volatile boolean shuttingDown = false;
    protected static final String DATA = "data";
    protected static final String OWNER_NAME = "ownerName";
    protected static final String LEASE_DURATION = "leaseDuration";
    protected static final String RECORD_VERSION_NUMBER = "recordVersionNumber";
    protected static final String IS_RELEASED = "isReleased";
    protected static final String IS_RELEASED_VALUE = "1";
    protected static final AttributeValue IS_RELEASED_ATTRIBUTE_VALUE;
    protected static volatile AtomicInteger lockClientId;
    protected static final Boolean IS_RELEASED_INDICATOR;
    private static final long DEFAULT_BUFFER_MS = 1000L;

    public AmazonDynamoDBLockClient(AmazonDynamoDBLockClientOptions amazonDynamoDBLockClientOptions) {
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getDynamoDBClient(), "DynamoDB client object cannot be null");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getTableName(), "Table name cannot be null");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getOwnerName(), "Owner name cannot be null");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getTimeUnit(), "Time unit cannot be null");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getPartitionKeyName(), "Partition Key Name cannot be null");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getSortKeyName(), "Sort Key Name cannot be null (use Optional.absent())");
        Objects.requireNonNull(amazonDynamoDBLockClientOptions.getNamedThreadCreator(), "Named thread creator cannot be null");
        this.dynamoDB = amazonDynamoDBLockClientOptions.getDynamoDBClient();
        this.tableName = amazonDynamoDBLockClientOptions.getTableName();
        this.locks = new ConcurrentHashMap();
        this.sessionMonitors = new ConcurrentHashMap();
        this.ownerName = amazonDynamoDBLockClientOptions.getOwnerName();
        this.leaseDurationInMilliseconds = amazonDynamoDBLockClientOptions.getTimeUnit().toMillis(amazonDynamoDBLockClientOptions.getLeaseDuration());
        this.heartbeatPeriodInMilliseconds = amazonDynamoDBLockClientOptions.getTimeUnit().toMillis(amazonDynamoDBLockClientOptions.getHeartbeatPeriod());
        this.partitionKeyName = amazonDynamoDBLockClientOptions.getPartitionKeyName();
        this.sortKeyName = amazonDynamoDBLockClientOptions.getSortKeyName();
        this.namedThreadCreator = amazonDynamoDBLockClientOptions.getNamedThreadCreator();
        this.holdLockOnServiceUnavailable = amazonDynamoDBLockClientOptions.getHoldLockOnServiceUnavailable();
        if (amazonDynamoDBLockClientOptions.getCreateHeartbeatBackgroundThread().booleanValue()) {
            if (this.leaseDurationInMilliseconds < 2L * this.heartbeatPeriodInMilliseconds) {
                throw new IllegalArgumentException("Heartbeat period must be no more than half the length of the Lease Duration, or locks might expire due to the heartbeat thread taking too long to update them (recommendation is to make it much greater, for example 4+ times greater)");
            }
            this.backgroundThread = Optional.of(this.startBackgroundThread());
        } else {
            this.backgroundThread = Optional.empty();
        }
    }

    public boolean lockTableExists() {
        try {
            DescribeTableResult result = this.dynamoDB.describeTable(new DescribeTableRequest().withTableName(this.tableName));
            return availableStatuses.contains((Object)TableStatus.fromValue(result.getTable().getTableStatus()));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
    }

    public void assertLockTableExists() throws LockTableDoesNotExistException {
        boolean exists;
        try {
            exists = this.lockTableExists();
        }
        catch (Exception e) {
            throw new LockTableDoesNotExistException("Lock table " + this.tableName + " does not exist", e);
        }
        if (!exists) {
            throw new LockTableDoesNotExistException("Lock table " + this.tableName + " does not exist");
        }
    }

    public static void createLockTableInDynamoDB(CreateDynamoDBTableOptions createDynamoDBTableOptions) {
        Objects.requireNonNull(createDynamoDBTableOptions.getDynamoDBClient(), "DynamoDB client object cannot be null");
        Objects.requireNonNull(createDynamoDBTableOptions.getTableName(), "Table name cannot be null");
        Objects.requireNonNull(createDynamoDBTableOptions.getProvisionedThroughput(), "Provisioned throughput cannot be null");
        Objects.requireNonNull(createDynamoDBTableOptions.getPartitionKeyName(), "Hash Key Name cannot be null");
        Objects.requireNonNull(createDynamoDBTableOptions.getSortKeyName(), "Sort Key Name cannot be null");
        KeySchemaElement partitionKeyElement = new KeySchemaElement();
        partitionKeyElement.setAttributeName(createDynamoDBTableOptions.getPartitionKeyName());
        partitionKeyElement.setKeyType(KeyType.HASH);
        ArrayList<KeySchemaElement> keySchema = new ArrayList<KeySchemaElement>();
        keySchema.add(partitionKeyElement);
        ArrayList<AttributeDefinition> attributeDefinitions = new ArrayList<AttributeDefinition>();
        attributeDefinitions.add(new AttributeDefinition().withAttributeName(createDynamoDBTableOptions.getPartitionKeyName()).withAttributeType(ScalarAttributeType.S));
        if (createDynamoDBTableOptions.getSortKeyName().isPresent()) {
            KeySchemaElement sortKeyElement = new KeySchemaElement();
            sortKeyElement.setAttributeName(createDynamoDBTableOptions.getSortKeyName().get());
            sortKeyElement.setKeyType(KeyType.RANGE);
            keySchema.add(sortKeyElement);
            attributeDefinitions.add(new AttributeDefinition().withAttributeName(createDynamoDBTableOptions.getSortKeyName().get()).withAttributeType(ScalarAttributeType.S));
        }
        CreateTableRequest createTableRequest = new CreateTableRequest(createDynamoDBTableOptions.getTableName(), keySchema);
        createTableRequest.setProvisionedThroughput(createDynamoDBTableOptions.getProvisionedThroughput());
        createTableRequest.setAttributeDefinitions(attributeDefinitions);
        if (createDynamoDBTableOptions.getRequestMetricCollector().isPresent()) {
            createTableRequest.setRequestMetricCollector(createDynamoDBTableOptions.getRequestMetricCollector().get());
        }
        createDynamoDBTableOptions.getDynamoDBClient().createTable(createTableRequest);
    }

    public LockItem acquireLock(AcquireLockOptions options) throws LockNotGrantedException, InterruptedException {
        Objects.requireNonNull(options, "Cannot acquire lock when options is null");
        Objects.requireNonNull(options.getPartitionKey(), "Cannot acquire lock when key is null");
        String key = options.getPartitionKey();
        Optional<String> sortKey = options.getSortKey();
        if (options.getAdditionalAttributes().containsKey(this.partitionKeyName) || options.getAdditionalAttributes().containsKey(OWNER_NAME) || options.getAdditionalAttributes().containsKey(LEASE_DURATION) || options.getAdditionalAttributes().containsKey(RECORD_VERSION_NUMBER) || options.getAdditionalAttributes().containsKey(DATA) || this.sortKeyName.isPresent() && options.getAdditionalAttributes().containsKey(this.sortKeyName.get())) {
            throw new IllegalArgumentException(String.format("Additional attribute cannot be one of the following types: %s, %s, %s, %s, %s", this.partitionKeyName, OWNER_NAME, LEASE_DURATION, RECORD_VERSION_NUMBER, DATA));
        }
        long millisecondsToWait = 1000L;
        if (options.getAdditionalTimeToWaitForLock() != null) {
            Objects.requireNonNull(options.getTimeUnit(), "timeUnit must not be null if additionalTimeToWaitForLock is non-null");
            millisecondsToWait = options.getTimeUnit().toMillis(options.getAdditionalTimeToWaitForLock());
        }
        long refreshPeriodInMilliseconds = 1000L;
        if (options.getRefreshPeriod() != null) {
            Objects.requireNonNull(options.getTimeUnit(), "timeUnit must not be null if refreshPeriod is non-null");
            refreshPeriodInMilliseconds = options.getTimeUnit().toMillis(options.getRefreshPeriod());
        }
        boolean deleteLockOnRelease = options.getDeleteLockOnRelease();
        boolean replaceData = options.getReplaceData();
        Optional<SessionMonitor> sessionMonitor = options.getSessionMonitor();
        if (sessionMonitor.isPresent()) {
            AmazonDynamoDBLockClient.sessionMonitorArgsValidate(sessionMonitor.get().getSafeTimeMillis(), this.heartbeatPeriodInMilliseconds, this.leaseDurationInMilliseconds);
        }
        long currentTimeMillis = LockClientUtils.INSTANCE.millisecondTime();
        LockItem lockTryingToBeAcquired = null;
        boolean alreadySleptOnceForOneLeasePeriod = false;
        GetLockOptions getLockOptions = new GetLockOptions.GetLockOptionsBuilder(key).withSortKey(sortKey.orElse(null)).withDeleteLockOnRelease(deleteLockOnRelease).withRequestMetricCollector(options.getRequestMetricCollector().orElse(null)).build();
        while (true) {
            block26: {
                try {
                    try {
                        logger.trace((Object)("Call GetItem to see if the lock for " + this.partitionKeyName + " =" + key + ", " + this.sortKeyName + "=" + sortKey + " exists in the table"));
                        Optional<LockItem> existingLock = this.getLockFromDynamoDB(getLockOptions);
                        if (options.getAcquireOnlyIfLockAlreadyExists().booleanValue() && !existingLock.isPresent()) {
                            throw new LockNotGrantedException("Lock does not exist.");
                        }
                        if (options.shouldSkipBlockingWait() && existingLock.isPresent() && !existingLock.get().isExpired()) {
                            throw new LockCurrentlyUnavailableException("The lock being requested is being held by another client.");
                        }
                        Optional<Object> newLockData = Optional.empty();
                        if (replaceData) {
                            newLockData = options.getData();
                        } else if (existingLock.isPresent()) {
                            newLockData = existingLock.get().getData();
                        }
                        if (!newLockData.isPresent()) {
                            newLockData = options.getData();
                        }
                        HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>();
                        item.putAll(options.getAdditionalAttributes());
                        item.put(this.partitionKeyName, new AttributeValue().withS(key));
                        item.put(OWNER_NAME, new AttributeValue().withS(this.ownerName));
                        item.put(LEASE_DURATION, new AttributeValue().withS(String.valueOf(this.leaseDurationInMilliseconds)));
                        String recordVersionNumber = this.generateRecordVersionNumber();
                        item.put(RECORD_VERSION_NUMBER, new AttributeValue().withS(String.valueOf(recordVersionNumber)));
                        this.sortKeyName.ifPresent(sortKeyName -> item.put((String)sortKeyName, new AttributeValue().withS((String)sortKey.get())));
                        newLockData.ifPresent(byteBuffer -> item.put(DATA, new AttributeValue().withB((ByteBuffer)byteBuffer)));
                        if (!existingLock.isPresent() && !options.getAcquireOnlyIfLockAlreadyExists().booleanValue()) {
                            return this.upsertAndMonitorNewLock(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, item, recordVersionNumber);
                        }
                        if (existingLock.isPresent() && existingLock.get().isReleased()) {
                            return this.upsertAndMonitorReleasedLock(options, key, sortKey, deleteLockOnRelease, sessionMonitor, existingLock, newLockData, item, recordVersionNumber);
                        }
                        if (lockTryingToBeAcquired == null) {
                            lockTryingToBeAcquired = existingLock.get();
                            if (!alreadySleptOnceForOneLeasePeriod) {
                                alreadySleptOnceForOneLeasePeriod = true;
                                millisecondsToWait += existingLock.get().getLeaseDuration();
                            }
                        } else if (lockTryingToBeAcquired.getRecordVersionNumber().equals(existingLock.get().getRecordVersionNumber())) {
                            if (lockTryingToBeAcquired.isExpired()) {
                                return this.upsertAndMonitorExpiredLock(options, key, sortKey, deleteLockOnRelease, sessionMonitor, existingLock, newLockData, item, recordVersionNumber);
                            }
                        } else {
                            lockTryingToBeAcquired = existingLock.get();
                        }
                    }
                    catch (ConditionalCheckFailedException conditionalCheckFailedException) {
                        logger.debug((Object)"Someone else acquired the lock", (Throwable)conditionalCheckFailedException);
                        throw new LockNotGrantedException("Could not acquire lock because someone else acquired it: ", conditionalCheckFailedException);
                    }
                    catch (ProvisionedThroughputExceededException provisionedThroughputExceededException) {
                        logger.debug((Object)"Maximum allowed provisioned throughput for the table exceeded", (Throwable)provisionedThroughputExceededException);
                        throw new LockNotGrantedException("Could not acquire lock because provisioned throughput for the table exceeded", provisionedThroughputExceededException);
                    }
                    catch (AmazonClientException amazonClientException) {
                        logger.warn((Object)"Could not acquire lock because of a client side failure in talking to DDB", (Throwable)amazonClientException);
                    }
                }
                catch (LockNotGrantedException x) {
                    if (LockClientUtils.INSTANCE.millisecondTime() - currentTimeMillis <= millisecondsToWait) break block26;
                    logger.debug((Object)("This client waited more than millisecondsToWait=" + millisecondsToWait + " ms since the beginning of this acquire call."), (Throwable)x);
                    throw x;
                }
            }
            if (LockClientUtils.INSTANCE.millisecondTime() - currentTimeMillis > millisecondsToWait) {
                throw new LockNotGrantedException("Didn't acquire lock after sleeping for " + (LockClientUtils.INSTANCE.millisecondTime() - currentTimeMillis) + " milliseconds");
            }
            logger.trace((Object)("Sleeping for a refresh period of " + refreshPeriodInMilliseconds + " ms"));
            Thread.sleep(refreshPeriodInMilliseconds);
        }
    }

    private LockItem upsertAndMonitorExpiredLock(AcquireLockOptions options, String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<SessionMonitor> sessionMonitor, Optional<LockItem> existingLock, Optional<ByteBuffer> newLockData, Map<String, AttributeValue> item, String recordVersionNumber) {
        String conditionalExpression;
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        boolean updateExistingLockRecord = options.getUpdateExistingLockRecord();
        expressionAttributeValues.put(RVN_VALUE_EXPRESSION_VARIABLE, new AttributeValue(existingLock.get().getRecordVersionNumber()));
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(PK_PATH_EXPRESSION_VARIABLE, this.partitionKeyName);
        expressionAttributeNames.put(RVN_PATH_EXPRESSION_VARIABLE, RECORD_VERSION_NUMBER);
        if (this.sortKeyName.isPresent()) {
            conditionalExpression = PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION;
            expressionAttributeNames.put(SK_PATH_EXPRESSION_VARIABLE, this.sortKeyName.get());
        } else {
            conditionalExpression = PK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION;
        }
        if (updateExistingLockRecord) {
            item.remove(this.partitionKeyName);
            if (this.sortKeyName.isPresent()) {
                item.remove(this.sortKeyName.get());
            }
            String updateExpression = this.getUpdateExpressionAndUpdateNameValueMaps(item, expressionAttributeNames, expressionAttributeValues);
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(this.getItemKeys(existingLock.get())).withUpdateExpression(updateExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues).withConditionExpression(conditionalExpression);
            logger.trace((Object)("Acquiring an existing lock whose revisionVersionNumber did not change for " + this.partitionKeyName + " partitionKeyName=" + key + ", " + this.sortKeyName + "=" + sortKey));
            return this.updateItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, updateItemRequest);
        }
        PutItemRequest putItemRequest = new PutItemRequest().withItem(item).withTableName(this.tableName).withConditionExpression(conditionalExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues);
        logger.trace((Object)("Acquiring an existing lock whose revisionVersionNumber did not change for " + this.partitionKeyName + " partitionKeyName=" + key + ", " + this.sortKeyName + "=" + sortKey));
        return this.putLockItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, putItemRequest);
    }

    private LockItem upsertAndMonitorReleasedLock(AcquireLockOptions options, String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<SessionMonitor> sessionMonitor, Optional<LockItem> existingLock, Optional<ByteBuffer> newLockData, Map<String, AttributeValue> item, String recordVersionNumber) {
        String conditionalExpression;
        boolean updateExistingLockRecord = options.getUpdateExistingLockRecord();
        boolean consistentLockData = options.getAcquireReleasedLocksConsistently();
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
        if (consistentLockData) {
            expressionAttributeValues.put(RVN_VALUE_EXPRESSION_VARIABLE, new AttributeValue(existingLock.get().getRecordVersionNumber()));
            expressionAttributeNames.put(RVN_PATH_EXPRESSION_VARIABLE, RECORD_VERSION_NUMBER);
        }
        expressionAttributeNames.put(PK_PATH_EXPRESSION_VARIABLE, this.partitionKeyName);
        expressionAttributeNames.put(IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED);
        if (this.sortKeyName.isPresent()) {
            conditionalExpression = consistentLockData ? PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION : PK_EXISTS_AND_SK_EXISTS_AND_IS_RELEASED_CONDITION;
            expressionAttributeNames.put(SK_PATH_EXPRESSION_VARIABLE, this.sortKeyName.get());
        } else {
            conditionalExpression = consistentLockData ? PK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION : PK_EXISTS_AND_IS_RELEASED_CONDITION;
        }
        expressionAttributeValues.put(IS_RELEASED_VALUE_EXPRESSION_VARIABLE, IS_RELEASED_ATTRIBUTE_VALUE);
        if (updateExistingLockRecord) {
            item.remove(this.partitionKeyName);
            if (this.sortKeyName.isPresent()) {
                item.remove(this.sortKeyName.get());
            }
            String updateExpression = this.getUpdateExpressionAndUpdateNameValueMaps(item, expressionAttributeNames, expressionAttributeValues) + REMOVE_IS_RELEASED_UPDATE_EXPRESSION;
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(this.getItemKeys(existingLock.get())).withUpdateExpression(updateExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues).withConditionExpression(conditionalExpression);
            logger.trace((Object)("Acquiring an existing released whose revisionVersionNumber did not change for " + this.partitionKeyName + " partitionKeyName=" + key + ", " + this.sortKeyName + "=" + sortKey));
            return this.updateItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, updateItemRequest);
        }
        PutItemRequest putItemRequest = new PutItemRequest().withItem(item).withTableName(this.tableName).withConditionExpression(conditionalExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues);
        logger.trace((Object)("Acquiring an existing released lock whose revisionVersionNumber did not change for " + this.partitionKeyName + " partitionKeyName=" + key + ", " + this.sortKeyName + "=" + sortKey));
        return this.putLockItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, putItemRequest);
    }

    private LockItem updateItemAndStartSessionMonitor(AcquireLockOptions options, String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<SessionMonitor> sessionMonitor, Optional<ByteBuffer> newLockData, String recordVersionNumber, UpdateItemRequest updateItemRequest) {
        long lastUpdatedTime = LockClientUtils.INSTANCE.millisecondTime();
        if (options.getRequestMetricCollector().isPresent()) {
            updateItemRequest.setRequestMetricCollector(options.getRequestMetricCollector().get());
        }
        this.dynamoDB.updateItem(updateItemRequest);
        LockItem lockItem = new LockItem(this, key, sortKey, newLockData, deleteLockOnRelease, this.ownerName, this.leaseDurationInMilliseconds, lastUpdatedTime, recordVersionNumber, IS_RELEASED_INDICATOR == false, sessionMonitor, options.getAdditionalAttributes());
        this.locks.put(lockItem.getUniqueIdentifier(), lockItem);
        this.tryAddSessionMonitor(lockItem.getUniqueIdentifier(), lockItem);
        return lockItem;
    }

    private LockItem upsertAndMonitorNewLock(AcquireLockOptions options, String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<SessionMonitor> sessionMonitor, Optional<ByteBuffer> newLockData, Map<String, AttributeValue> item, String recordVersionNumber) {
        String conditionalExpression;
        HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
        expressionAttributeNames.put(PK_PATH_EXPRESSION_VARIABLE, this.partitionKeyName);
        boolean updateExistingLockRecord = options.getUpdateExistingLockRecord();
        if (this.sortKeyName.isPresent()) {
            conditionalExpression = ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_SK_CONDITION;
            expressionAttributeNames.put(SK_PATH_EXPRESSION_VARIABLE, this.sortKeyName.get());
        } else {
            conditionalExpression = ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_CONDITION;
        }
        if (updateExistingLockRecord) {
            item.remove(this.partitionKeyName);
            if (this.sortKeyName.isPresent()) {
                item.remove(this.sortKeyName.get());
            }
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            String updateExpression = this.getUpdateExpressionAndUpdateNameValueMaps(item, expressionAttributeNames, expressionAttributeValues);
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(this.getKeys(key, sortKey)).withUpdateExpression(updateExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues).withConditionExpression(conditionalExpression);
            logger.trace((Object)("Acquiring a new lock on " + this.partitionKeyName + "=" + key + ", " + this.sortKeyName + "=" + sortKey));
            return this.updateItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, updateItemRequest);
        }
        PutItemRequest putItemRequest = new PutItemRequest().withItem(item).withTableName(this.tableName).withConditionExpression(conditionalExpression).withExpressionAttributeNames(expressionAttributeNames);
        logger.trace((Object)("Acquiring a new lock on " + this.partitionKeyName + "=" + key + ", " + this.sortKeyName + "=" + sortKey));
        return this.putLockItemAndStartSessionMonitor(options, key, sortKey, deleteLockOnRelease, sessionMonitor, newLockData, recordVersionNumber, putItemRequest);
    }

    private LockItem putLockItemAndStartSessionMonitor(AcquireLockOptions options, String key, Optional<String> sortKey, boolean deleteLockOnRelease, Optional<SessionMonitor> sessionMonitor, Optional<ByteBuffer> newLockData, String recordVersionNumber, PutItemRequest putItemRequest) {
        long lastUpdatedTime = LockClientUtils.INSTANCE.millisecondTime();
        if (options.getRequestMetricCollector().isPresent()) {
            putItemRequest.setRequestMetricCollector(options.getRequestMetricCollector().get());
        }
        this.dynamoDB.putItem(putItemRequest);
        LockItem lockItem = new LockItem(this, key, sortKey, newLockData, deleteLockOnRelease, this.ownerName, this.leaseDurationInMilliseconds, lastUpdatedTime, recordVersionNumber, false, sessionMonitor, options.getAdditionalAttributes());
        this.locks.put(lockItem.getUniqueIdentifier(), lockItem);
        this.tryAddSessionMonitor(lockItem.getUniqueIdentifier(), lockItem);
        return lockItem;
    }

    private String getUpdateExpressionAndUpdateNameValueMaps(Map<String, AttributeValue> item, Map<String, String> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues) {
        String additionalUpdateExpression = "SET ";
        StringBuilder updateExpressionBuilder = new StringBuilder("SET ");
        int i = 0;
        Iterator<Map.Entry<String, AttributeValue>> iterator2 = item.entrySet().iterator();
        String expressionSeparator = ",";
        while (iterator2.hasNext()) {
            Map.Entry<String, AttributeValue> entry = iterator2.next();
            String keyExpression = "#k" + i;
            String valueExpression = ":v" + i;
            expressionAttributeNames.put(keyExpression, entry.getKey());
            expressionAttributeValues.put(valueExpression, entry.getValue());
            if (!iterator2.hasNext()) {
                expressionSeparator = "";
            }
            updateExpressionBuilder.append("#k").append(i).append("=").append(":v").append(i).append(expressionSeparator);
            ++i;
        }
        return updateExpressionBuilder.toString();
    }

    public Optional<LockItem> tryAcquireLock(AcquireLockOptions options) throws InterruptedException {
        try {
            return Optional.of(this.acquireLock(options));
        }
        catch (LockNotGrantedException x) {
            return Optional.empty();
        }
    }

    public boolean releaseLock(LockItem lockItem) {
        return this.releaseLock(ReleaseLockOptions.builder(lockItem).withDeleteLock(lockItem.getDeleteLockItemOnClose()).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(ReleaseLockOptions options) {
        Objects.requireNonNull(options, "ReleaseLockOptions cannot be null");
        LockItem lockItem = options.getLockItem();
        boolean deleteLock = options.isDeleteLock();
        boolean bestEffort = options.isBestEffort();
        Optional<ByteBuffer> data = options.getData();
        Objects.requireNonNull(lockItem, "Cannot release null lockItem");
        if (!lockItem.getOwnerName().equals(this.ownerName)) {
            return false;
        }
        LockItem lockItem2 = lockItem;
        synchronized (lockItem2) {
            try {
                String conditionalExpression;
                this.locks.remove(lockItem.getUniqueIdentifier());
                HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
                expressionAttributeValues.put(RVN_VALUE_EXPRESSION_VARIABLE, new AttributeValue(lockItem.getRecordVersionNumber()));
                expressionAttributeValues.put(OWNER_NAME_VALUE_EXPRESSION_VARIABLE, new AttributeValue(lockItem.getOwnerName()));
                HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
                expressionAttributeNames.put(PK_PATH_EXPRESSION_VARIABLE, this.partitionKeyName);
                expressionAttributeNames.put(OWNER_NAME_PATH_EXPRESSION_VARIABLE, OWNER_NAME);
                expressionAttributeNames.put(RVN_PATH_EXPRESSION_VARIABLE, RECORD_VERSION_NUMBER);
                if (this.sortKeyName.isPresent()) {
                    conditionalExpression = PK_EXISTS_AND_SK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
                    expressionAttributeNames.put(SK_PATH_EXPRESSION_VARIABLE, this.sortKeyName.get());
                } else {
                    conditionalExpression = PK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
                }
                Map<String, AttributeValue> key = this.getItemKeys(lockItem);
                if (deleteLock) {
                    DeleteItemRequest deleteItemRequest = new DeleteItemRequest(this.tableName, key);
                    if (options.getRequestMetricCollector().isPresent()) {
                        deleteItemRequest.setRequestMetricCollector(options.getRequestMetricCollector().get());
                    }
                    this.dynamoDB.deleteItem(deleteItemRequest.withConditionExpression(conditionalExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues));
                } else {
                    String updateExpression;
                    expressionAttributeNames.put(IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED);
                    expressionAttributeValues.put(IS_RELEASED_VALUE_EXPRESSION_VARIABLE, IS_RELEASED_ATTRIBUTE_VALUE);
                    if (data.isPresent()) {
                        updateExpression = UPDATE_IS_RELEASED_AND_DATA;
                        expressionAttributeNames.put(DATA_PATH_EXPRESSION_VARIABLE, DATA);
                        expressionAttributeValues.put(DATA_VALUE_EXPRESSION_VARIABLE, new AttributeValue().withB(data.get()));
                    } else {
                        updateExpression = UPDATE_IS_RELEASED;
                    }
                    UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(key).withUpdateExpression(updateExpression).withConditionExpression(conditionalExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues);
                    if (options.getRequestMetricCollector().isPresent()) {
                        updateItemRequest.setRequestMetricCollector(options.getRequestMetricCollector().get());
                    }
                    this.dynamoDB.updateItem(updateItemRequest);
                }
            }
            catch (ConditionalCheckFailedException conditionalCheckFailedException) {
                logger.debug((Object)"Someone else acquired the lock before you asked to release it", (Throwable)conditionalCheckFailedException);
                return false;
            }
            catch (AmazonClientException amazonClientException) {
                if (bestEffort) {
                    logger.warn((Object)"Ignore AmazonClientException and continue to clean up", (Throwable)amazonClientException);
                }
                throw amazonClientException;
            }
            this.removeKillSessionMonitor(lockItem.getUniqueIdentifier());
        }
        return true;
    }

    private Map<String, AttributeValue> getItemKeys(LockItem lockItem) {
        return this.getKeys(lockItem.getPartitionKey(), lockItem.getSortKey());
    }

    private Map<String, AttributeValue> getKeys(String partitionKey, Optional<String> sortKey) {
        HashMap<String, AttributeValue> key = new HashMap<String, AttributeValue>();
        key.put(this.partitionKeyName, new AttributeValue().withS(partitionKey));
        if (sortKey.isPresent()) {
            key.put(this.sortKeyName.get(), new AttributeValue().withS(sortKey.get()));
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseAllLocks() {
        HashMap<String, LockItem> locks;
        HashMap<String, LockItem> hashMap = locks = new HashMap<String, LockItem>(this.locks);
        synchronized (hashMap) {
            for (Map.Entry lockEntry : locks.entrySet()) {
                this.releaseLock((LockItem)lockEntry.getValue());
            }
        }
    }

    public Optional<LockItem> getLock(String key, Optional<String> sortKey) {
        Objects.requireNonNull(sortKey, "Sort Key must not be null (can be Optional.empty())");
        LockItem localLock = this.locks.get(key + sortKey.orElse(""));
        if (localLock != null) {
            return Optional.of(localLock);
        }
        Optional<LockItem> lockItem = this.getLockFromDynamoDB(new GetLockOptions.GetLockOptionsBuilder(key).withSortKey(sortKey.orElse(null)).withDeleteLockOnRelease(false).build());
        if (lockItem.isPresent()) {
            if (lockItem.get().isReleased()) {
                return Optional.empty();
            }
            lockItem.get().updateRecordVersionNumber("", 0L, lockItem.get().getLeaseDuration());
        }
        return lockItem;
    }

    public Optional<LockItem> getLockFromDynamoDB(GetLockOptions options) {
        Objects.requireNonNull(options, "AcquireLockOptions cannot be null");
        Objects.requireNonNull(options.getPartitionKey(), "Cannot lookup null key");
        GetItemResult result = this.readFromDynamoDB(options.getPartitionKey(), options.getSortKey(), options.getRequestMetricCollector());
        Map<String, AttributeValue> item = result.getItem();
        if (item == null) {
            return Optional.empty();
        }
        return Optional.of(this.createLockItem(options, item));
    }

    private LockItem createLockItem(GetLockOptions options, Map<String, AttributeValue> item) {
        Optional<ByteBuffer> data = Optional.ofNullable(item.get(DATA)).map(dataAttributionValue -> {
            item.remove(DATA);
            return dataAttributionValue.getB();
        });
        AttributeValue ownerName = item.remove(OWNER_NAME);
        AttributeValue leaseDuration = item.remove(LEASE_DURATION);
        AttributeValue recordVersionNumber = item.remove(RECORD_VERSION_NUMBER);
        boolean isReleased = item.containsKey(IS_RELEASED);
        item.remove(IS_RELEASED);
        item.remove(this.partitionKeyName);
        long lookupTime = LockClientUtils.INSTANCE.millisecondTime();
        LockItem lockItem = new LockItem(this, options.getPartitionKey(), options.getSortKey(), data, options.isDeleteLockOnRelease(), ownerName.getS(), Long.parseLong(leaseDuration.getS()), lookupTime, recordVersionNumber.getS(), isReleased, Optional.empty(), item);
        return lockItem;
    }

    public Stream<LockItem> getAllLocksFromDynamoDB(boolean deleteOnRelease) {
        ScanRequest scanRequest = new ScanRequest().withTableName(this.tableName);
        LockItemPaginatedScanIterator iterator2 = new LockItemPaginatedScanIterator(this.dynamoDB, scanRequest, item -> {
            String key = ((AttributeValue)item.get(this.partitionKeyName)).getS();
            GetLockOptions.GetLockOptionsBuilder options = GetLockOptions.builder(key).withDeleteLockOnRelease(deleteOnRelease);
            options = this.sortKeyName.map(item::get).map(AttributeValue::getS).map(options::withSortKey).orElse(options);
            LockItem lockItem = this.createLockItem(options.build(), item);
            return lockItem;
        });
        Iterable iterable = () -> iterator2;
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public void sendHeartbeat(LockItem lockItem) {
        this.sendHeartbeat(SendHeartbeatOptions.builder(lockItem).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeartbeat(SendHeartbeatOptions options) {
        LockItem lockItem;
        boolean deleteData;
        Objects.requireNonNull(options, "options is required");
        Objects.requireNonNull(options.getLockItem(), "Cannot send heartbeat for null lock");
        boolean bl = deleteData = options.getDeleteData() != null && options.getDeleteData() != false;
        if (deleteData && options.getData().isPresent()) {
            throw new IllegalArgumentException("data must not be present if deleteData is true");
        }
        long leaseDurationToEnsureInMilliseconds = this.leaseDurationInMilliseconds;
        if (options.getLeaseDurationToEnsure() != null) {
            Objects.requireNonNull(options.getTimeUnit(), "TimeUnit must not be null if leaseDurationToEnsure is not null");
            leaseDurationToEnsureInMilliseconds = options.getTimeUnit().toMillis(options.getLeaseDurationToEnsure());
        }
        if ((lockItem = options.getLockItem()).isExpired() || !lockItem.getOwnerName().equals(this.ownerName) || lockItem.isReleased()) {
            this.locks.remove(lockItem.getUniqueIdentifier());
            throw new LockNotGrantedException("Cannot send heartbeat because lock is not granted");
        }
        LockItem lockItem2 = lockItem;
        synchronized (lockItem2) {
            String updateExpression;
            String conditionalExpression;
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            expressionAttributeValues.put(RVN_VALUE_EXPRESSION_VARIABLE, new AttributeValue(lockItem.getRecordVersionNumber()));
            expressionAttributeValues.put(OWNER_NAME_VALUE_EXPRESSION_VARIABLE, new AttributeValue(lockItem.getOwnerName()));
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            expressionAttributeNames.put(PK_PATH_EXPRESSION_VARIABLE, this.partitionKeyName);
            expressionAttributeNames.put(LEASE_DURATION_PATH_VALUE_EXPRESSION_VARIABLE, LEASE_DURATION);
            expressionAttributeNames.put(RVN_PATH_EXPRESSION_VARIABLE, RECORD_VERSION_NUMBER);
            expressionAttributeNames.put(OWNER_NAME_PATH_EXPRESSION_VARIABLE, OWNER_NAME);
            if (this.sortKeyName.isPresent()) {
                conditionalExpression = PK_EXISTS_AND_SK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
                expressionAttributeNames.put(SK_PATH_EXPRESSION_VARIABLE, this.sortKeyName.get());
            } else {
                conditionalExpression = PK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION;
            }
            String recordVersionNumber = this.generateRecordVersionNumber();
            expressionAttributeValues.put(NEW_RVN_VALUE_EXPRESSION_VARIABLE, new AttributeValue(recordVersionNumber));
            expressionAttributeValues.put(LEASE_DURATION_VALUE_EXPRESSION_VARIABLE, new AttributeValue(String.valueOf(leaseDurationToEnsureInMilliseconds)));
            if (deleteData) {
                expressionAttributeNames.put(DATA_PATH_EXPRESSION_VARIABLE, DATA);
                updateExpression = UPDATE_LEASE_DURATION_AND_RVN_AND_REMOVE_DATA;
            } else if (options.getData().isPresent()) {
                expressionAttributeNames.put(DATA_PATH_EXPRESSION_VARIABLE, DATA);
                expressionAttributeValues.put(DATA_VALUE_EXPRESSION_VARIABLE, new AttributeValue().withB(options.getData().get()));
                updateExpression = UPDATE_LEASE_DURATION_AND_RVN_AND_DATA;
            } else {
                updateExpression = UPDATE_LEASE_DURATION_AND_RVN;
            }
            UpdateItemRequest updateItemRequest = new UpdateItemRequest().withTableName(this.tableName).withKey(this.getItemKeys(lockItem)).withConditionExpression(conditionalExpression).withUpdateExpression(updateExpression).withExpressionAttributeNames(expressionAttributeNames).withExpressionAttributeValues(expressionAttributeValues);
            if (options.getRequestMetricCollector().isPresent()) {
                updateItemRequest.setRequestMetricCollector(options.getRequestMetricCollector().get());
            }
            try {
                long lastUpdateOfLock = LockClientUtils.INSTANCE.millisecondTime();
                this.dynamoDB.updateItem(updateItemRequest);
                lockItem.updateRecordVersionNumber(recordVersionNumber, lastUpdateOfLock, leaseDurationToEnsureInMilliseconds);
            }
            catch (ConditionalCheckFailedException conditionalCheckFailedException) {
                logger.debug((Object)"Someone else acquired the lock, so we will stop heartbeating it", (Throwable)conditionalCheckFailedException);
                this.locks.remove(lockItem.getUniqueIdentifier());
                throw new LockNotGrantedException("Someone else acquired the lock, so we will stop heartbeating it", conditionalCheckFailedException);
            }
            catch (AmazonServiceException amazonServiceException) {
                if (this.holdLockOnServiceUnavailable && amazonServiceException.getStatusCode() == 503) {
                    logger.info((Object)"DynamoDB Service Unavailable. Holding the lock.");
                    lockItem.updateLookUpTime(LockClientUtils.INSTANCE.millisecondTime());
                }
                throw amazonServiceException;
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    if (this.shuttingDown) {
                        throw new InterruptedException();
                    }
                    long timeWorkBegins = LockClientUtils.INSTANCE.millisecondTime();
                    HashMap<String, LockItem> workingCopyOfLocks = new HashMap<String, LockItem>(this.locks);
                    for (Map.Entry lockEntry : workingCopyOfLocks.entrySet()) {
                        try {
                            this.sendHeartbeat((LockItem)lockEntry.getValue());
                        }
                        catch (LockNotGrantedException x) {
                            logger.debug((Object)("Heartbeat failed for " + lockEntry), (Throwable)x);
                        }
                        catch (RuntimeException x) {
                            logger.warn((Object)("Exception sending heartbeat for " + lockEntry), (Throwable)x);
                        }
                    }
                    long timeElapsed = LockClientUtils.INSTANCE.millisecondTime() - timeWorkBegins;
                    if (this.shuttingDown) {
                        throw new InterruptedException();
                    }
                    Thread.sleep(Math.max(this.heartbeatPeriodInMilliseconds - timeElapsed, 0L));
                }
            }
            catch (InterruptedException e) {
                logger.info((Object)"Heartbeat thread recieved interrupt, exiting run() (possibly exiting thread)", (Throwable)e);
                return;
            }
            catch (RuntimeException x) {
                logger.warn((Object)"Exception sending heartbeat", (Throwable)x);
                continue;
            }
            break;
        }
    }

    @Override
    public void close() throws IOException {
        this.releaseAllLocks();
        if (this.backgroundThread.isPresent()) {
            this.shuttingDown = true;
            this.backgroundThread.get().interrupt();
            try {
                this.backgroundThread.get().join();
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Caught InterruptedException waiting for background thread to exit, interrupting current thread");
                Thread.currentThread().interrupt();
            }
        }
    }

    private GetItemResult readFromDynamoDB(String key, Optional<String> sortKey, Optional<RequestMetricCollector> requestMetricCollector) {
        HashMap<String, AttributeValue> dynamoDBKey = new HashMap<String, AttributeValue>();
        dynamoDBKey.put(this.partitionKeyName, new AttributeValue().withS(key));
        if (this.sortKeyName.isPresent()) {
            dynamoDBKey.put(this.sortKeyName.get(), new AttributeValue().withS(sortKey.get()));
        }
        GetItemRequest getItemRequest = new GetItemRequest(this.tableName, dynamoDBKey);
        getItemRequest.setConsistentRead(true);
        if (requestMetricCollector.isPresent()) {
            getItemRequest.setRequestMetricCollector(requestMetricCollector.get());
        }
        return this.dynamoDB.getItem(getItemRequest);
    }

    private Thread startBackgroundThread() {
        Thread t = this.namedThreadCreator.apply("dynamodb-lock-client-" + lockClientId.addAndGet(1)).newThread(this);
        t.setDaemon(true);
        t.start();
        return t;
    }

    private String generateRecordVersionNumber() {
        return UUID.randomUUID().toString();
    }

    private void tryAddSessionMonitor(String lockName, LockItem lock) {
        if (lock.hasSessionMonitor() && lock.hasCallback()) {
            Thread monitorThread = this.lockSessionMonitorChecker(lockName, lock);
            monitorThread.setDaemon(true);
            monitorThread.start();
            this.sessionMonitors.put(lockName, monitorThread);
        }
    }

    private void removeKillSessionMonitor(String monitorName) {
        if (this.sessionMonitors.containsKey(monitorName)) {
            Thread monitor = this.sessionMonitors.remove(monitorName);
            monitor.interrupt();
            try {
                monitor.join();
            }
            catch (InterruptedException e) {
                logger.warn((Object)"Caught InterruptedException waiting for session monitor thread to exit, ignoring");
            }
        }
    }

    private static void sessionMonitorArgsValidate(long safeTimeWithoutHeartbeatMillis, long heartbeatPeriodMillis, long leaseDurationMillis) throws IllegalArgumentException {
        if (safeTimeWithoutHeartbeatMillis <= heartbeatPeriodMillis) {
            throw new IllegalArgumentException("safeTimeWithoutHeartbeat must be greater than heartbeat frequency");
        }
        if (safeTimeWithoutHeartbeatMillis >= leaseDurationMillis) {
            throw new IllegalArgumentException("safeTimeWithoutHeartbeat must be less than the lock's lease duration");
        }
    }

    private Thread lockSessionMonitorChecker(String monitorName, LockItem lock) {
        return this.namedThreadCreator.apply(monitorName + "-sessionMonitor").newThread(() -> {
            try {
                long millisUntilDangerZone;
                while ((millisUntilDangerZone = lock.millisecondsUntilDangerZoneEntered()) > 0L) {
                    Thread.sleep(millisUntilDangerZone);
                }
                lock.runSessionMonitor();
                this.sessionMonitors.remove(monitorName);
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        });
    }

    static {
        ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_CONDITION = String.format("attribute_not_exists(%s)", PK_PATH_EXPRESSION_VARIABLE);
        ACQUIRE_LOCK_THAT_DOESNT_EXIST_PK_SK_CONDITION = String.format("attribute_not_exists(%s) AND attribute_not_exists(%s)", PK_PATH_EXPRESSION_VARIABLE, SK_PATH_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_IS_RELEASED_CONDITION = String.format("attribute_exists(%s) AND %s = %s", PK_PATH_EXPRESSION_VARIABLE, IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_SK_EXISTS_AND_IS_RELEASED_CONDITION = String.format("attribute_exists(%s) AND attribute_exists(%s) AND %s = %s", PK_PATH_EXPRESSION_VARIABLE, SK_PATH_EXPRESSION_VARIABLE, IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION = String.format("attribute_exists(%s) AND attribute_exists(%s) AND %s = %s AND %s = %s", PK_PATH_EXPRESSION_VARIABLE, SK_PATH_EXPRESSION_VARIABLE, RVN_PATH_EXPRESSION_VARIABLE, RVN_VALUE_EXPRESSION_VARIABLE, IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION = String.format("attribute_exists(%s) AND attribute_exists(%s) AND %s = %s", PK_PATH_EXPRESSION_VARIABLE, SK_PATH_EXPRESSION_VARIABLE, RVN_PATH_EXPRESSION_VARIABLE, RVN_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_SK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION = String.format("%s AND %s = %s ", PK_EXISTS_AND_SK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION, OWNER_NAME_PATH_EXPRESSION_VARIABLE, OWNER_NAME_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_RVN_IS_THE_SAME_AND_IS_RELEASED_CONDITION = String.format("(attribute_exists(%s) AND %s = %s AND %s = %s)", PK_PATH_EXPRESSION_VARIABLE, RVN_PATH_EXPRESSION_VARIABLE, RVN_VALUE_EXPRESSION_VARIABLE, IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION = String.format("attribute_exists(%s) AND %s = %s", PK_PATH_EXPRESSION_VARIABLE, RVN_PATH_EXPRESSION_VARIABLE, RVN_VALUE_EXPRESSION_VARIABLE);
        PK_EXISTS_AND_OWNER_NAME_SAME_AND_RVN_SAME_CONDITION = String.format("%s AND %s = %s", PK_EXISTS_AND_RVN_IS_THE_SAME_CONDITION, OWNER_NAME_PATH_EXPRESSION_VARIABLE, OWNER_NAME_VALUE_EXPRESSION_VARIABLE);
        UPDATE_IS_RELEASED = String.format("SET %s = %s", IS_RELEASED_PATH_EXPRESSION_VARIABLE, IS_RELEASED_VALUE_EXPRESSION_VARIABLE);
        UPDATE_IS_RELEASED_AND_DATA = String.format("%s, %s = %s", UPDATE_IS_RELEASED, DATA_PATH_EXPRESSION_VARIABLE, DATA_VALUE_EXPRESSION_VARIABLE);
        UPDATE_LEASE_DURATION_AND_RVN = String.format("SET %s = %s, %s = %s", LEASE_DURATION_PATH_VALUE_EXPRESSION_VARIABLE, LEASE_DURATION_VALUE_EXPRESSION_VARIABLE, RVN_PATH_EXPRESSION_VARIABLE, NEW_RVN_VALUE_EXPRESSION_VARIABLE);
        UPDATE_LEASE_DURATION_AND_RVN_AND_REMOVE_DATA = String.format("%s REMOVE %s", UPDATE_LEASE_DURATION_AND_RVN, DATA_PATH_EXPRESSION_VARIABLE);
        UPDATE_LEASE_DURATION_AND_RVN_AND_DATA = String.format("%s, %s = %s", UPDATE_LEASE_DURATION_AND_RVN, DATA_PATH_EXPRESSION_VARIABLE, DATA_VALUE_EXPRESSION_VARIABLE);
        REMOVE_IS_RELEASED_UPDATE_EXPRESSION = String.format(" REMOVE %s ", IS_RELEASED_PATH_EXPRESSION_VARIABLE);
        availableStatuses = new HashSet<TableStatus>();
        availableStatuses.add(TableStatus.ACTIVE);
        availableStatuses.add(TableStatus.UPDATING);
        IS_RELEASED_ATTRIBUTE_VALUE = new AttributeValue(IS_RELEASED_VALUE);
        lockClientId = new AtomicInteger(0);
        IS_RELEASED_INDICATOR = true;
    }
}

