/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.commons.codec.binary.Base64;

@InterfaceAudience.Private
public class SaslUtil {
    private static final Log log = LogFactory.getLog(SaslUtil.class);
    public static final String SASL_DEFAULT_REALM = "default";
    public static final Map<String, String> SASL_PROPS = new TreeMap<String, String>();
    public static final int SWITCH_TO_SIMPLE_AUTH = -88;

    public static String[] splitKerberosName(String fullName) {
        return fullName.split("[/@]");
    }

    static String encodeIdentifier(byte[] identifier) {
        return new String(Base64.encodeBase64(identifier));
    }

    static byte[] decodeIdentifier(String identifier) {
        return Base64.decodeBase64(identifier.getBytes());
    }

    static char[] encodePassword(byte[] password) {
        return new String(Base64.encodeBase64(password)).toCharArray();
    }

    public static QualityOfProtection getQop(String stringQop) {
        QualityOfProtection qop = null;
        if (QualityOfProtection.AUTHENTICATION.name().toLowerCase().equals(stringQop) || QualityOfProtection.AUTHENTICATION.saslQop.equals(stringQop)) {
            qop = QualityOfProtection.AUTHENTICATION;
        } else if (QualityOfProtection.INTEGRITY.name().toLowerCase().equals(stringQop) || QualityOfProtection.INTEGRITY.saslQop.equals(stringQop)) {
            qop = QualityOfProtection.INTEGRITY;
        } else if (QualityOfProtection.PRIVACY.name().toLowerCase().equals(stringQop) || QualityOfProtection.PRIVACY.saslQop.equals(stringQop)) {
            qop = QualityOfProtection.PRIVACY;
        }
        if (qop == null) {
            throw new IllegalArgumentException("Invalid qop: " + stringQop + ". It must be one of 'authentication', 'integrity', 'privacy'.");
        }
        if (QualityOfProtection.AUTHENTICATION.saslQop.equals(stringQop) || QualityOfProtection.INTEGRITY.saslQop.equals(stringQop) || QualityOfProtection.PRIVACY.saslQop.equals(stringQop)) {
            log.warn((Object)"Use authentication/integrity/privacy as value for rpc protection configurations instead of auth/auth-int/auth-conf.");
        }
        return qop;
    }

    static void initSaslProperties(String rpcProtection) {
        QualityOfProtection saslQOP = SaslUtil.getQop(rpcProtection);
        if (saslQOP == null) {
            saslQOP = QualityOfProtection.AUTHENTICATION;
        }
        SASL_PROPS.put("javax.security.sasl.qop", saslQOP.getSaslQop());
        SASL_PROPS.put("javax.security.sasl.server.authentication", "true");
    }

    public static enum QualityOfProtection {
        AUTHENTICATION("auth"),
        INTEGRITY("auth-int"),
        PRIVACY("auth-conf");

        public final String saslQop;

        private QualityOfProtection(String saslQop) {
            this.saslQop = saslQop;
        }

        public String getSaslQop() {
            return this.saslQop;
        }
    }
}

