/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionHelper$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)records -> {
            Iterator iterator2;
            if (records.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                Schema schema = new Schema.Parser().parse(schemaStr);
                StructType dataType = MODULE$.convertAvroSchemaToStructType(schema);
                Function1<Object, Object> convertor = AvroConversionHelper$.MODULE$.createConverterToRow(schema, (DataType)dataType);
                iterator2 = records.map((Function1 & Serializable & scala.Serializable)x -> (Row)convertor.apply(x));
            }
            return iterator2;
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(StructType structType, String structName, String recordNamespace) {
        return this.getAvroSchemaWithDefaults(SchemaConverters$.MODULE$.toAvroType((DataType)structType, false, structName, recordNamespace));
    }

    public Schema getAvroSchemaWithDefaults(Schema schema) {
        Schema schema2;
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            List modifiedFields = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getFields()).map((Function1 & Serializable & scala.Serializable)field -> {
                Schema.Field field2;
                Schema newSchema = MODULE$.getAvroSchemaWithDefaults(field.schema());
                Schema.Type type = field.schema().getType();
                if (Schema.Type.UNION.equals(type)) {
                    Schema.Field field3;
                    java.util.List innerFields = newSchema.getTypes();
                    boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(nullFieldEncountered, schema) -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$2(BoxesRunTime.unboxToBoolean((Object)nullFieldEncountered), schema))));
                    if (containsNullSchema) {
                        Schema restructuredNewSchema = Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).filter((Function1 & Serializable & scala.Serializable)innerSchema -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$3(innerSchema))), List$.MODULE$.canBuildFrom())));
                        field3 = new Schema.Field(field.name(), restructuredNewSchema, field.doc(), (Object)JsonProperties.NULL_VALUE);
                    } else {
                        field3 = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal());
                    }
                    field2 = field3;
                } else {
                    field2 = new Schema.Field(field.name(), newSchema, field.doc(), field.defaultVal());
                }
                return field2;
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            schema2 = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)modifiedFields));
        } else {
            schema2 = Schema.Type.UNION.equals(type) ? Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getTypes()).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema), Buffer$.MODULE$.canBuildFrom()))) : (Schema.Type.MAP.equals(type) ? Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema.getValueType())) : (Schema.Type.ARRAY.equals(type) ? Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema.getElementType())) : schema));
        }
        return schema2;
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        return (StructType)SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
    }

    public GenericRecord buildAvroRecordBySchema(IndexedRecord record, Schema requiredSchema, List<Object> requiredPos, GenericRecordBuilder recordBuilder) {
        Buffer requiredFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(requiredSchema.getFields()).asScala();
        Predef$.MODULE$.assert(requiredFields.length() == requiredPos.length());
        Iterator positionIterator = requiredPos.iterator();
        requiredFields.foreach((Function1 & Serializable & scala.Serializable)f -> recordBuilder.set(f, record.get(BoxesRunTime.unboxToInt((Object)positionIterator.next()))));
        return recordBuilder.build();
    }

    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String name = HoodieAvroUtils.sanitizeName(tableName);
        return new Tuple2((Object)new StringBuilder(7).append(name).append("_record").toString(), (Object)new StringBuilder(7).append("hoodie.").append(name).toString());
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$2(boolean nullFieldEncountered, Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return nullFieldEncountered | !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$3(Schema innerSchema) {
        Schema.Type type = innerSchema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

