/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.Serializable;
import java.time.DateTimeException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.util.DateTimeUtils;
import org.apache.hudi.common.util.Option;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

@PublicAPIClass(maturity=ApiMaturityLevel.STABLE)
public class WriteStatus
implements Serializable {
    private static final Logger LOG = LogManager.getLogger(WriteStatus.class);
    private static final long serialVersionUID = 1L;
    private static final long RANDOM_SEED = 9038412832L;
    private final HashMap<HoodieKey, Throwable> errors = new HashMap();
    private final List<HoodieRecord> writtenRecords = new ArrayList<HoodieRecord>();
    private final List<HoodieRecord> failedRecords = new ArrayList<HoodieRecord>();
    private Throwable globalError = null;
    private String fileId = null;
    private String partitionPath = null;
    private HoodieWriteStat stat = null;
    private long totalRecords = 0L;
    private long totalErrorRecords = 0L;
    private final double failureFraction;
    private final boolean trackSuccessRecords;
    private final transient Random random;

    public WriteStatus(Boolean trackSuccessRecords, Double failureFraction) {
        this.trackSuccessRecords = trackSuccessRecords;
        this.failureFraction = failureFraction;
        this.random = new Random(9038412832L);
    }

    public WriteStatus() {
        this.failureFraction = 0.0;
        this.trackSuccessRecords = false;
        this.random = null;
    }

    public void markSuccess(HoodieRecord record, Option<Map<String, String>> optionalRecordMetadata) {
        if (this.trackSuccessRecords) {
            this.writtenRecords.add(record);
        }
        ++this.totalRecords;
        if (optionalRecordMetadata.isPresent()) {
            String eventTimeVal = optionalRecordMetadata.get().getOrDefault("metadata.event_time.key", null);
            try {
                long eventTime = DateTimeUtils.parseDateTime(eventTimeVal).toEpochMilli();
                this.stat.setMinEventTime(eventTime);
                this.stat.setMaxEventTime(eventTime);
            }
            catch (IllegalArgumentException | DateTimeException e) {
                LOG.debug((Object)String.format("Fail to parse event time value: %s", eventTimeVal), (Throwable)e);
            }
        }
    }

    public void markFailure(HoodieRecord record, Throwable t, Option<Map<String, String>> optionalRecordMetadata) {
        if (this.failedRecords.isEmpty() || this.random.nextDouble() <= this.failureFraction) {
            this.failedRecords.add(record);
            this.errors.put(record.getKey(), t);
        }
        ++this.totalRecords;
        ++this.totalErrorRecords;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public boolean hasErrors() {
        return this.totalErrorRecords > 0L;
    }

    public boolean isErrored(HoodieKey key) {
        return this.errors.containsKey(key);
    }

    public HashMap<HoodieKey, Throwable> getErrors() {
        return this.errors;
    }

    public boolean hasGlobalError() {
        return this.globalError != null;
    }

    public Throwable getGlobalError() {
        return this.globalError;
    }

    public void setGlobalError(Throwable t) {
        this.globalError = t;
    }

    public List<HoodieRecord> getWrittenRecords() {
        return this.writtenRecords;
    }

    public List<HoodieRecord> getFailedRecords() {
        return this.failedRecords;
    }

    public HoodieWriteStat getStat() {
        return this.stat;
    }

    public void setStat(HoodieWriteStat stat) {
        this.stat = stat;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getTotalErrorRecords() {
        return this.totalErrorRecords;
    }

    public void setTotalErrorRecords(long totalErrorRecords) {
        this.totalErrorRecords = totalErrorRecords;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteStatus {");
        sb.append("fileId=").append(this.fileId);
        sb.append(", writeStat=").append(this.stat);
        sb.append(", globalError='").append(this.globalError).append('\'');
        sb.append(", hasErrors='").append(this.hasErrors()).append('\'');
        sb.append(", errorCount='").append(this.totalErrorRecords).append('\'');
        sb.append(", errorPct='").append(100.0 * (double)this.totalErrorRecords / (double)this.totalRecords).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

