/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;

@ConfigClassProperty(name="Consistency Guard Configurations", groupName=ConfigGroups.Names.WRITE_CLIENT, description="The consistency guard related config options, to help talk to eventually consistent object storage.(Tip: S3 is NOT eventually consistent anymore!)")
public class ConsistencyGuardConfig
extends HoodieConfig {
    public static final ConfigProperty<String> ENABLE = ConfigProperty.key("hoodie.consistency.check.enabled").defaultValue("false").sinceVersion("0.5.0").deprecatedAfter("0.7.0").withDocumentation("Enabled to handle S3 eventual consistency issue. This property is no longer required since S3 is now strongly consistent. Will be removed in the future releases.");
    public static final ConfigProperty<Long> INITIAL_CHECK_INTERVAL_MS = ConfigProperty.key("hoodie.consistency.check.initial_interval_ms").defaultValue(400L).sinceVersion("0.5.0").deprecatedAfter("0.7.0").withDocumentation("Amount of time (in ms) to wait, before checking for consistency after an operation on storage.");
    public static final ConfigProperty<Long> MAX_CHECK_INTERVAL_MS = ConfigProperty.key("hoodie.consistency.check.max_interval_ms").defaultValue(20000L).sinceVersion("0.5.0").deprecatedAfter("0.7.0").withDocumentation("Maximum amount of time (in ms), to wait for consistency checking.");
    public static final ConfigProperty<Integer> MAX_CHECKS = ConfigProperty.key("hoodie.consistency.check.max_checks").defaultValue(6).sinceVersion("0.5.0").deprecatedAfter("0.7.0").withDocumentation("Maximum number of consistency checks to perform, with exponential backoff.");
    public static final ConfigProperty<Long> OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS = ConfigProperty.key("hoodie.optimistic.consistency.guard.sleep_time_ms").defaultValue(500L).sinceVersion("0.6.0").withDocumentation("Amount of time (in ms), to wait after which we assume storage is consistent.");
    public static final ConfigProperty<Boolean> OPTIMISTIC_CONSISTENCY_GUARD_ENABLE = ConfigProperty.key("_hoodie.optimistic.consistency.guard.enable").defaultValue(false).sinceVersion("0.6.0").withDocumentation("Enable consistency guard, which optimistically assumes consistency is achieved after a certain time period.");
    @Deprecated
    private static final String CONSISTENCY_CHECK_ENABLED_PROP = ENABLE.key();
    @Deprecated
    private static final String DEFAULT_CONSISTENCY_CHECK_ENABLED = ENABLE.defaultValue();
    @Deprecated
    private static final String INITIAL_CONSISTENCY_CHECK_INTERVAL_MS_PROP = INITIAL_CHECK_INTERVAL_MS.key();
    @Deprecated
    private static long DEFAULT_INITIAL_CONSISTENCY_CHECK_INTERVAL_MS = INITIAL_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    private static final String MAX_CONSISTENCY_CHECK_INTERVAL_MS_PROP = MAX_CHECK_INTERVAL_MS.key();
    @Deprecated
    private static long DEFAULT_MAX_CONSISTENCY_CHECK_INTERVAL_MS = MAX_CHECK_INTERVAL_MS.defaultValue();
    @Deprecated
    private static final String MAX_CONSISTENCY_CHECKS_PROP = MAX_CHECKS.key();
    @Deprecated
    private static int DEFAULT_MAX_CONSISTENCY_CHECKS = MAX_CHECKS.defaultValue();
    @Deprecated
    private static final String OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS_PROP = OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS.key();
    @Deprecated
    private static long DEFAULT_OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS_PROP = OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS.defaultValue();
    @Deprecated
    private static final String ENABLE_OPTIMISTIC_CONSISTENCY_GUARD = OPTIMISTIC_CONSISTENCY_GUARD_ENABLE.key();
    @Deprecated
    private static boolean DEFAULT_ENABLE_OPTIMISTIC_CONSISTENCY_GUARD = OPTIMISTIC_CONSISTENCY_GUARD_ENABLE.defaultValue();

    private ConsistencyGuardConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isConsistencyCheckEnabled() {
        return this.getBoolean(ENABLE);
    }

    public int getMaxConsistencyChecks() {
        return this.getInt(MAX_CHECKS);
    }

    public int getInitialConsistencyCheckIntervalMs() {
        return this.getInt(INITIAL_CHECK_INTERVAL_MS);
    }

    public int getMaxConsistencyCheckIntervalMs() {
        return this.getInt(MAX_CHECK_INTERVAL_MS);
    }

    public long getOptimisticConsistencyGuardSleepTimeMs() {
        return this.getLong(OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS);
    }

    public boolean shouldEnableOptimisticConsistencyGuard() {
        return this.getBoolean(OPTIMISTIC_CONSISTENCY_GUARD_ENABLE);
    }

    public static class Builder {
        private final ConsistencyGuardConfig consistencyGuardConfig = new ConsistencyGuardConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.consistencyGuardConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.consistencyGuardConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder withConsistencyCheckEnabled(boolean enabled) {
            this.consistencyGuardConfig.setValue(ENABLE, String.valueOf(enabled));
            return this;
        }

        public Builder withInitialConsistencyCheckIntervalMs(int initialIntevalMs) {
            this.consistencyGuardConfig.setValue(INITIAL_CHECK_INTERVAL_MS, String.valueOf(initialIntevalMs));
            return this;
        }

        public Builder withMaxConsistencyCheckIntervalMs(int maxIntervalMs) {
            this.consistencyGuardConfig.setValue(MAX_CHECK_INTERVAL_MS, String.valueOf(maxIntervalMs));
            return this;
        }

        public Builder withMaxConsistencyChecks(int maxConsistencyChecks) {
            this.consistencyGuardConfig.setValue(MAX_CHECKS, String.valueOf(maxConsistencyChecks));
            return this;
        }

        public Builder withOptimisticConsistencyGuardSleepTimeMs(long sleepTimeMs) {
            this.consistencyGuardConfig.setValue(OPTIMISTIC_CONSISTENCY_GUARD_SLEEP_TIME_MS, String.valueOf(sleepTimeMs));
            return this;
        }

        public Builder withEnableOptimisticConsistencyGuard(boolean enableOptimisticConsistencyGuard) {
            this.consistencyGuardConfig.setValue(OPTIMISTIC_CONSISTENCY_GUARD_ENABLE, String.valueOf(enableOptimisticConsistencyGuard));
            return this;
        }

        public ConsistencyGuardConfig build() {
            this.consistencyGuardConfig.setDefaults(ConsistencyGuardConfig.class.getName());
            return this.consistencyGuardConfig;
        }
    }
}

