/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class RDDCustomColumnsSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final SerializableSchema serializableSchema;

    public RDDCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this.serializableSchema = new SerializableSchema(new Schema.Parser().parse(config.getSchema()));
        this.sortColumnNames = this.getSortColumnName(config);
    }

    public RDDCustomColumnsSortPartitioner(String[] columnNames, Schema schema) {
        this.sortColumnNames = columnNames;
        this.serializableSchema = new SerializableSchema(schema);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        String[] sortColumns = this.sortColumnNames;
        SerializableSchema schema = this.serializableSchema;
        return records.sortBy((Function & Serializable)record -> HoodieAvroUtils.getRecordColumnValues((HoodieRecord<? extends HoodieRecordPayload>)record, sortColumns, schema), true, outputSparkPartitions);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private String[] getSortColumnName(HoodieWriteConfig config) {
        return config.getUserDefinedBulkInsertPartitionerSortColumns().split(",");
    }
}

