/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.HoodieSparkUtils;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.OrderingIndexHelper;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class RDDSpatialCurveOptimizationSortPartitioner<T extends HoodieRecordPayload>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final HoodieSparkEngineContext sparkEngineContext;
    private final SerializableSchema serializableSchema;
    private final HoodieWriteConfig config;

    public RDDSpatialCurveOptimizationSortPartitioner(HoodieSparkEngineContext sparkEngineContext, HoodieWriteConfig config, Schema schema) {
        this.sparkEngineContext = sparkEngineContext;
        this.config = config;
        this.serializableSchema = new SerializableSchema(schema);
    }

    @Override
    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        String payloadClass = this.config.getPayloadClass();
        JavaRDD<GenericRecord> preparedRecord = this.prepareGenericRecord(records, outputSparkPartitions, this.serializableSchema.get());
        return preparedRecord.map((Function & Serializable)record -> {
            String key = record.get("_hoodie_record_key").toString();
            String partition = record.get("_hoodie_partition_path").toString();
            HoodieKey hoodieKey = new HoodieKey(key, partition);
            Object avroPayload = ReflectionUtils.loadPayload(payloadClass, new Object[]{Option.of(record)}, Option.class);
            HoodieRecord hoodieRecord = new HoodieRecord(hoodieKey, avroPayload);
            return hoodieRecord;
        });
    }

    private JavaRDD<GenericRecord> prepareGenericRecord(JavaRDD<HoodieRecord<T>> inputRecords, int numOutputGroups, Schema schema) {
        Dataset<Row> zDataFrame;
        SerializableSchema serializableSchema = new SerializableSchema(schema);
        JavaRDD genericRecordJavaRDD = inputRecords.map((Function & Serializable)f -> (GenericRecord)f.getData().getInsertValue(serializableSchema.get()).get());
        Dataset<Row> originDF = AvroConversionUtils.createDataFrame((RDD<GenericRecord>)genericRecordJavaRDD.rdd(), schema.toString(), this.sparkEngineContext.getSqlContext().sparkSession());
        switch (this.config.getLayoutOptimizationCurveBuildMethod()) {
            case DIRECT: {
                zDataFrame = OrderingIndexHelper.createOptimizedDataFrameByMapValue(originDF, this.config.getClusteringSortColumns(), numOutputGroups, this.config.getLayoutOptimizationStrategy());
                break;
            }
            case SAMPLE: {
                zDataFrame = OrderingIndexHelper.createOptimizeDataFrameBySample(originDF, this.config.getClusteringSortColumns(), numOutputGroups, this.config.getLayoutOptimizationStrategy());
                break;
            }
            default: {
                throw new HoodieException("Not a valid build curve method for doWriteOperation: ");
            }
        }
        return HoodieSparkUtils.createRdd(zDataFrame, schema.getName(), schema.getNamespace(), false, Option.empty()).toJavaRDD();
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return true;
    }
}

