/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import org.apache.hudi.common.util.ValidationUtils;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class Parquet2SparkSchemaUtils {
    public static String convertToSparkSchemaJson(GroupType parquetSchema) {
        String fieldsJsonString = parquetSchema.getFields().stream().map(field -> {
            switch (field.getRepetition()) {
                case OPTIONAL: {
                    return "{\"name\":\"" + field.getName() + "\",\"type\":" + Parquet2SparkSchemaUtils.convertFieldType(field) + ",\"nullable\":true,\"metadata\":{}}";
                }
                case REQUIRED: {
                    return "{\"name\":\"" + field.getName() + "\",\"type\":" + Parquet2SparkSchemaUtils.convertFieldType(field) + ",\"nullable\":false,\"metadata\":{}}";
                }
                case REPEATED: {
                    String arrayType = Parquet2SparkSchemaUtils.arrayType(field, false);
                    return "{\"name\":\"" + field.getName() + "\",\"type\":" + arrayType + ",\"nullable\":false,\"metadata\":{}}";
                }
            }
            throw new UnsupportedOperationException("Unsupport convert " + field + " to spark sql type");
        }).reduce((a, b) -> a + "," + b).orElse("");
        return "{\"type\":\"struct\",\"fields\":[" + fieldsJsonString + "]}";
    }

    private static String convertFieldType(Type field) {
        if (field instanceof PrimitiveType) {
            return "\"" + Parquet2SparkSchemaUtils.convertPrimitiveType((PrimitiveType)field) + "\"";
        }
        assert (field instanceof GroupType);
        return Parquet2SparkSchemaUtils.convertGroupField((GroupType)field);
    }

    private static String convertPrimitiveType(PrimitiveType field) {
        PrimitiveType.PrimitiveTypeName typeName = field.getPrimitiveTypeName();
        OriginalType originalType = field.getOriginalType();
        switch (typeName) {
            case BOOLEAN: {
                return "boolean";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case INT32: {
                if (originalType == null) {
                    return "integer";
                }
                switch (originalType) {
                    case INT_8: {
                        return "byte";
                    }
                    case INT_16: {
                        return "short";
                    }
                    case INT_32: {
                        return "integer";
                    }
                    case DATE: {
                        return "date";
                    }
                    case DECIMAL: {
                        return "decimal(" + field.getDecimalMetadata().getPrecision() + "," + field.getDecimalMetadata().getScale() + ")";
                    }
                }
                throw new UnsupportedOperationException("Unsupport convert " + typeName + " to spark sql type");
            }
            case INT64: {
                if (originalType == null) {
                    return "long";
                }
                switch (originalType) {
                    case INT_64: {
                        return "long";
                    }
                    case DECIMAL: {
                        return "decimal(" + field.getDecimalMetadata().getPrecision() + "," + field.getDecimalMetadata().getScale() + ")";
                    }
                    case TIMESTAMP_MICROS: 
                    case TIMESTAMP_MILLIS: {
                        return "timestamp";
                    }
                }
                throw new UnsupportedOperationException("Unsupport convert " + typeName + " to spark sql type");
            }
            case INT96: {
                return "timestamp";
            }
            case BINARY: {
                if (originalType == null) {
                    return "binary";
                }
                switch (originalType) {
                    case UTF8: 
                    case ENUM: 
                    case JSON: {
                        return "string";
                    }
                    case BSON: {
                        return "binary";
                    }
                    case DECIMAL: {
                        return "decimal(" + field.getDecimalMetadata().getPrecision() + "," + field.getDecimalMetadata().getScale() + ")";
                    }
                }
                throw new UnsupportedOperationException("Unsupport convert " + typeName + " to spark sql type");
            }
            case FIXED_LEN_BYTE_ARRAY: {
                switch (originalType) {
                    case DECIMAL: {
                        return "decimal(" + field.getDecimalMetadata().getPrecision() + "," + field.getDecimalMetadata().getScale() + ")";
                    }
                }
                throw new UnsupportedOperationException("Unsupport convert " + typeName + " to spark sql type");
            }
        }
        throw new UnsupportedOperationException("Unsupport convert " + typeName + " to spark sql type");
    }

    private static String convertGroupField(GroupType field) {
        if (field.getOriginalType() == null) {
            return Parquet2SparkSchemaUtils.convertToSparkSchemaJson(field);
        }
        switch (field.getOriginalType()) {
            case LIST: {
                ValidationUtils.checkArgument(field.getFieldCount() == 1, "Illegal List type: " + field);
                Type repeatedType = field.getType(0);
                if (Parquet2SparkSchemaUtils.isElementType(repeatedType, field.getName())) {
                    return Parquet2SparkSchemaUtils.arrayType(repeatedType, false);
                }
                Type elementType = repeatedType.asGroupType().getType(0);
                boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                return Parquet2SparkSchemaUtils.arrayType(elementType, optional);
            }
            case MAP: 
            case MAP_KEY_VALUE: {
                GroupType keyValueType = field.getType(0).asGroupType();
                Type keyType = keyValueType.getType(0);
                Type valueType = keyValueType.getType(1);
                boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                return "{\"type\":\"map\", \"keyType\":" + Parquet2SparkSchemaUtils.convertFieldType(keyType) + ",\"valueType\":" + Parquet2SparkSchemaUtils.convertFieldType(valueType) + ",\"valueContainsNull\":" + valueOptional + "}";
            }
        }
        throw new UnsupportedOperationException("Unsupport convert " + field + " to spark sql type");
    }

    private static String arrayType(Type elementType, boolean containsNull) {
        return "{\"type\":\"array\", \"elementType\":" + Parquet2SparkSchemaUtils.convertFieldType(elementType) + ",\"containsNull\":" + containsNull + "}";
    }

    private static boolean isElementType(Type repeatedType, String parentName) {
        return repeatedType.isPrimitive() || repeatedType.asGroupType().getFieldCount() > 1 || repeatedType.getName().equals("array") || repeatedType.getName().equals(parentName + "_tuple");
    }
}

