/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.prometheus.client.dropwizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.hudi.com.codahale.metrics.Counter;
import org.apache.hudi.com.codahale.metrics.Gauge;
import org.apache.hudi.com.codahale.metrics.Histogram;
import org.apache.hudi.com.codahale.metrics.Meter;
import org.apache.hudi.com.codahale.metrics.Metric;
import org.apache.hudi.com.codahale.metrics.MetricRegistry;
import org.apache.hudi.com.codahale.metrics.Snapshot;
import org.apache.hudi.com.codahale.metrics.Timer;
import org.apache.hudi.io.prometheus.client.Collector;
import org.apache.hudi.io.prometheus.client.dropwizard.samplebuilder.DefaultSampleBuilder;
import org.apache.hudi.io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;

public class DropwizardExports
extends Collector
implements Collector.Describable {
    private static final Logger LOGGER = Logger.getLogger(DropwizardExports.class.getName());
    private MetricRegistry registry;
    private SampleBuilder sampleBuilder;

    public DropwizardExports(MetricRegistry registry) {
        this.registry = registry;
        this.sampleBuilder = new DefaultSampleBuilder();
    }

    public DropwizardExports(MetricRegistry registry, SampleBuilder sampleBuilder) {
        this.registry = registry;
        this.sampleBuilder = sampleBuilder;
    }

    private static String getHelpMessage(String metricName, Metric metric) {
        return String.format("Generated from Dropwizard metric import (metric=%s, type=%s)", metricName, metric.getClass().getName());
    }

    Collector.MetricFamilySamples fromCounter(String dropwizardName, Counter counter) {
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(dropwizardName, "", new ArrayList<String>(), new ArrayList<String>(), new Long(counter.getCount()).doubleValue());
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(dropwizardName, counter), Arrays.asList(sample));
    }

    Collector.MetricFamilySamples fromGauge(String dropwizardName, Gauge gauge) {
        double value;
        Object obj = gauge.getValue();
        if (obj instanceof Number) {
            value = ((Number)obj).doubleValue();
        } else if (obj instanceof Boolean) {
            value = (Boolean)obj != false ? 1.0 : 0.0;
        } else {
            LOGGER.log(Level.FINE, String.format("Invalid type for Gauge %s: %s", DropwizardExports.sanitizeMetricName(dropwizardName), obj == null ? "null" : obj.getClass().getName()));
            return null;
        }
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(dropwizardName, "", new ArrayList<String>(), new ArrayList<String>(), value);
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.GAUGE, DropwizardExports.getHelpMessage(dropwizardName, gauge), Arrays.asList(sample));
    }

    Collector.MetricFamilySamples fromSnapshotAndCount(String dropwizardName, Snapshot snapshot, long count, double factor, String helpMessage) {
        List<Collector.MetricFamilySamples.Sample> samples = Arrays.asList(this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.5"), snapshot.getMedian() * factor), this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.75"), snapshot.get75thPercentile() * factor), this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.95"), snapshot.get95thPercentile() * factor), this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.98"), snapshot.get98thPercentile() * factor), this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.99"), snapshot.get99thPercentile() * factor), this.sampleBuilder.createSample(dropwizardName, "", Arrays.asList("quantile"), Arrays.asList("0.999"), snapshot.get999thPercentile() * factor), this.sampleBuilder.createSample(dropwizardName, "_count", new ArrayList<String>(), new ArrayList<String>(), count));
        return new Collector.MetricFamilySamples(samples.get((int)0).name, Collector.Type.SUMMARY, helpMessage, samples);
    }

    Collector.MetricFamilySamples fromHistogram(String dropwizardName, Histogram histogram) {
        return this.fromSnapshotAndCount(dropwizardName, histogram.getSnapshot(), histogram.getCount(), 1.0, DropwizardExports.getHelpMessage(dropwizardName, histogram));
    }

    Collector.MetricFamilySamples fromTimer(String dropwizardName, Timer timer) {
        return this.fromSnapshotAndCount(dropwizardName, timer.getSnapshot(), timer.getCount(), 1.0 / (double)TimeUnit.SECONDS.toNanos(1L), DropwizardExports.getHelpMessage(dropwizardName, timer));
    }

    Collector.MetricFamilySamples fromMeter(String dropwizardName, Meter meter) {
        Collector.MetricFamilySamples.Sample sample = this.sampleBuilder.createSample(dropwizardName, "_total", new ArrayList<String>(), new ArrayList<String>(), meter.getCount());
        return new Collector.MetricFamilySamples(sample.name, Collector.Type.COUNTER, DropwizardExports.getHelpMessage(dropwizardName, meter), Arrays.asList(sample));
    }

    @Override
    public List<Collector.MetricFamilySamples> collect() {
        HashMap<String, Collector.MetricFamilySamples> mfSamplesMap = new HashMap<String, Collector.MetricFamilySamples>();
        for (Map.Entry<String, Gauge> entry : this.registry.getGauges().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromGauge(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<String, Metric> entry : this.registry.getCounters().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromCounter(entry.getKey(), (Counter)entry.getValue()));
        }
        for (Map.Entry<String, Metric> entry : this.registry.getHistograms().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromHistogram(entry.getKey(), (Histogram)entry.getValue()));
        }
        for (Map.Entry<String, Metric> entry : this.registry.getTimers().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromTimer(entry.getKey(), (Timer)entry.getValue()));
        }
        for (Map.Entry<String, Metric> entry : this.registry.getMeters().entrySet()) {
            this.addToMap(mfSamplesMap, this.fromMeter(entry.getKey(), (Meter)entry.getValue()));
        }
        return new ArrayList<Collector.MetricFamilySamples>(mfSamplesMap.values());
    }

    private void addToMap(Map<String, Collector.MetricFamilySamples> mfSamplesMap, Collector.MetricFamilySamples newMfSamples) {
        if (newMfSamples != null) {
            Collector.MetricFamilySamples currentMfSamples = mfSamplesMap.get(newMfSamples.name);
            if (currentMfSamples == null) {
                mfSamplesMap.put(newMfSamples.name, newMfSamples);
            } else {
                ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(currentMfSamples.samples);
                samples.addAll(newMfSamples.samples);
                mfSamplesMap.put(newMfSamples.name, new Collector.MetricFamilySamples(newMfSamples.name, currentMfSamples.type, currentMfSamples.help, samples));
            }
        }
    }

    @Override
    public List<Collector.MetricFamilySamples> describe() {
        return new ArrayList<Collector.MetricFamilySamples>();
    }
}

