/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class GlobalAvroDeleteKeyGenerator
extends BaseKeyGenerator {
    private static final String EMPTY_PARTITION = "";

    public GlobalAvroDeleteKeyGenerator(TypedProperties config) {
        super(config);
        this.recordKeyFields = Arrays.asList(config.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).split(","));
    }

    @Override
    public String getRecordKey(GenericRecord record) {
        return KeyGenUtils.getRecordKey(record, this.getRecordKeyFields());
    }

    @Override
    public String getPartitionPath(GenericRecord record) {
        return EMPTY_PARTITION;
    }

    @Override
    public List<String> getPartitionPathFields() {
        return new ArrayList<String>();
    }

    public String getEmptyPartition() {
        return EMPTY_PARTITION;
    }
}

