/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.org.eclipse.jetty.util.BufferUtil;
import org.apache.hudi.org.eclipse.jetty.websocket.api.MessageTooLargeException;

public class ByteAccumulator {
    private final List<byte[]> chunks = new ArrayList<byte[]>();
    private final int maxSize;
    private int length = 0;

    public ByteAccumulator(int maxOverallBufferSize) {
        this.maxSize = maxOverallBufferSize;
    }

    public void copyChunk(byte[] buf, int offset, int length) {
        if (this.length + length > this.maxSize) {
            String err = String.format("Resulting message size [%,d] is too large for configured max of [%,d]", this.length + length, this.maxSize);
            throw new MessageTooLargeException(err);
        }
        byte[] copy = new byte[length - offset];
        System.arraycopy(buf, offset, copy, 0, length);
        this.chunks.add(copy);
        this.length += length;
    }

    public int getLength() {
        return this.length;
    }

    public void transferTo(ByteBuffer buffer) {
        if (buffer.remaining() < this.length) {
            throw new IllegalArgumentException(String.format("Not enough space in ByteBuffer remaining [%d] for accumulated buffers length [%d]", buffer.remaining(), this.length));
        }
        int position = buffer.position();
        for (byte[] chunk : this.chunks) {
            buffer.put(chunk, 0, chunk.length);
        }
        BufferUtil.flipToFlush(buffer, position);
    }
}

