/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieSparkCopyOnWriteTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.bootstrap.HoodieBootstrapWriteMetadata;
import org.apache.hudi.table.action.bootstrap.SparkBootstrapDeltaCommitActionExecutor;
import org.apache.hudi.table.action.compact.HoodieSparkMergeOnReadTableCompactor;
import org.apache.hudi.table.action.compact.RunCompactionActionExecutor;
import org.apache.hudi.table.action.compact.ScheduleCompactionActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkBulkInsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkBulkInsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkDeleteDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkInsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkInsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkUpsertDeltaCommitActionExecutor;
import org.apache.hudi.table.action.deltacommit.SparkUpsertPreppedDeltaCommitActionExecutor;
import org.apache.hudi.table.action.restore.MergeOnReadRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.BaseRollbackPlanActionExecutor;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;
import org.apache.spark.api.java.JavaRDD;

public class HoodieSparkMergeOnReadTable<T extends HoodieRecordPayload>
extends HoodieSparkCopyOnWriteTable<T> {
    HoodieSparkMergeOnReadTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    @Override
    public boolean isTableServiceAction(String actionType) {
        return !actionType.equals("deltacommit");
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> upsert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkUpsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> insert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records) {
        return new SparkInsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> bulkInsert(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> records, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, records, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> delete(HoodieEngineContext context, String instantTime, JavaRDD<HoodieKey> keys2) {
        return new SparkDeleteDeltaCommitActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, keys2).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> upsertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords) {
        return new SparkUpsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> insertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords) {
        return new SparkInsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords).execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> bulkInsertPrepped(HoodieEngineContext context, String instantTime, JavaRDD<HoodieRecord<T>> preppedRecords, Option<BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>>> userDefinedBulkInsertPartitioner) {
        return new SparkBulkInsertPreppedDeltaCommitActionExecutor<T>((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, instantTime, preppedRecords, userDefinedBulkInsertPartitioner).execute();
    }

    @Override
    public Option<HoodieCompactionPlan> scheduleCompaction(HoodieEngineContext context, String instantTime, Option<Map<String, String>> extraMetadata) {
        ScheduleCompactionActionExecutor scheduleCompactionExecutor = new ScheduleCompactionActionExecutor(context, this.config, this, instantTime, extraMetadata, new HoodieSparkMergeOnReadTableCompactor());
        return scheduleCompactionExecutor.execute();
    }

    @Override
    public HoodieWriteMetadata<JavaRDD<WriteStatus>> compact(HoodieEngineContext context, String compactionInstantTime) {
        RunCompactionActionExecutor compactionExecutor = new RunCompactionActionExecutor(context, this.config, this, compactionInstantTime, new HoodieSparkMergeOnReadTableCompactor(), new HoodieSparkCopyOnWriteTable(this.config, context, this.getMetaClient()));
        return HoodieSparkMergeOnReadTable.convertMetadata((HoodieWriteMetadata<HoodieData<WriteStatus>>)compactionExecutor.execute());
    }

    @Override
    public HoodieBootstrapWriteMetadata<JavaRDD<WriteStatus>> bootstrap(HoodieEngineContext context, Option<Map<String, String>> extraMetadata) {
        return new SparkBootstrapDeltaCommitActionExecutor((HoodieSparkEngineContext)context, this.config, (HoodieTable)this, extraMetadata).execute();
    }

    @Override
    public void rollbackBootstrap(HoodieEngineContext context, String instantTime) {
        new MergeOnReadRestoreActionExecutor(context, this.config, this, instantTime, "00000000000000").execute();
    }

    @Override
    public Option<HoodieRollbackPlan> scheduleRollback(HoodieEngineContext context, String instantTime, HoodieInstant instantToRollback, boolean skipTimelinePublish, boolean shouldRollbackUsingMarkers) {
        return new BaseRollbackPlanActionExecutor(context, this.config, this, instantTime, instantToRollback, skipTimelinePublish, shouldRollbackUsingMarkers).execute();
    }

    @Override
    public HoodieRollbackMetadata rollback(HoodieEngineContext context, String rollbackInstantTime, HoodieInstant commitInstant, boolean deleteInstants, boolean skipLocking) {
        return new MergeOnReadRollbackActionExecutor(context, this.config, this, rollbackInstantTime, commitInstant, deleteInstants, skipLocking).execute();
    }

    @Override
    public HoodieRestoreMetadata restore(HoodieEngineContext context, String restoreInstantTime, String instantToRestore) {
        return new MergeOnReadRestoreActionExecutor(context, this.config, this, restoreInstantTime, instantToRestore).execute();
    }

    @Override
    public void finalizeWrite(HoodieEngineContext context, String instantTs, List<HoodieWriteStat> stats) throws HoodieIOException {
        super.finalizeWrite(context, instantTs, stats);
    }
}

