/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.deltastreamer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.utilities.deltastreamer.HoodieDeltaStreamer;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.spark.SparkConf;
import scala.Option;

public class SchedulerConfGenerator {
    private static final Logger LOG = LogManager.getLogger(SchedulerConfGenerator.class);
    public static final String DELTASYNC_POOL_NAME = "hoodiedeltasync";
    public static final String COMPACT_POOL_NAME = "hoodiecompact";
    public static final String SPARK_SCHEDULER_MODE_KEY = "spark.scheduler.mode";
    public static final String SPARK_SCHEDULER_FAIR_MODE = "FAIR";
    public static final String SPARK_SCHEDULER_ALLOCATION_FILE_KEY = "spark.scheduler.allocation.file";
    private static final String SPARK_SCHEDULING_PATTERN = "<?xml version=\"1.0\"?>\n<allocations>\n  <pool name=\"%s\">\n    <schedulingMode>%s</schedulingMode>\n    <weight>%s</weight>\n    <minShare>%s</minShare>\n  </pool>\n  <pool name=\"%s\">\n    <schedulingMode>%s</schedulingMode>\n    <weight>%s</weight>\n    <minShare>%s</minShare>\n  </pool>\n</allocations>";

    private static String generateConfig(Integer deltaSyncWeight, Integer compactionWeight, Integer deltaSyncMinShare, Integer compactionMinShare) {
        return String.format(SPARK_SCHEDULING_PATTERN, DELTASYNC_POOL_NAME, SPARK_SCHEDULER_FAIR_MODE, deltaSyncWeight.toString(), deltaSyncMinShare.toString(), COMPACT_POOL_NAME, SPARK_SCHEDULER_FAIR_MODE, compactionWeight.toString(), compactionMinShare.toString());
    }

    public static Map<String, String> getSparkSchedulingConfigs(HoodieDeltaStreamer.Config cfg) throws Exception {
        Option scheduleModeKeyOption = new SparkConf().getOption(SPARK_SCHEDULER_MODE_KEY);
        org.apache.hudi.common.util.Option sparkSchedulerMode = scheduleModeKeyOption.isDefined() ? org.apache.hudi.common.util.Option.of(scheduleModeKeyOption.get()) : org.apache.hudi.common.util.Option.empty();
        HashMap<String, String> additionalSparkConfigs = new HashMap<String, String>(1);
        if (sparkSchedulerMode.isPresent() && SPARK_SCHEDULER_FAIR_MODE.equals(sparkSchedulerMode.get()) && cfg.continuousMode.booleanValue() && cfg.tableType.equals(HoodieTableType.MERGE_ON_READ.name())) {
            String sparkSchedulingConfFile = SchedulerConfGenerator.generateAndStoreConfig(cfg.deltaSyncSchedulingWeight, cfg.compactSchedulingWeight, cfg.deltaSyncSchedulingMinShare, cfg.compactSchedulingMinShare);
            additionalSparkConfigs.put(SPARK_SCHEDULER_ALLOCATION_FILE_KEY, sparkSchedulingConfFile);
        } else {
            LOG.warn((Object)"Job Scheduling Configs will not be in effect as spark.scheduler.mode is not set to FAIR at instantiation time. Continuing without scheduling configs");
        }
        return additionalSparkConfigs;
    }

    private static String generateAndStoreConfig(Integer deltaSyncWeight, Integer compactionWeight, Integer deltaSyncMinShare, Integer compactionMinShare) throws IOException {
        File tempConfigFile = File.createTempFile(UUID.randomUUID().toString(), ".xml");
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempConfigFile));
        bw.write(SchedulerConfGenerator.generateConfig(deltaSyncWeight, compactionWeight, deltaSyncMinShare, compactionMinShare));
        bw.close();
        LOG.info((Object)("Configs written to file" + tempConfigFile.getAbsolutePath()));
        return tempConfigFile.getAbsolutePath();
    }
}

