/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.utilities.schema;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.utilities.schema.SchemaProvider;
import org.apache.spark.api.java.JavaSparkContext;

public class FilebasedSchemaProvider
extends SchemaProvider {
    private final FileSystem fs;
    protected Schema sourceSchema;
    protected Schema targetSchema;

    public FilebasedSchemaProvider(TypedProperties props, JavaSparkContext jssc) {
        super(props, jssc);
        DataSourceUtils.checkRequiredProperties(props, Collections.singletonList("hoodie.deltastreamer.schemaprovider.source.schema.file"));
        String sourceFile = props.getString("hoodie.deltastreamer.schemaprovider.source.schema.file");
        this.fs = FSUtils.getFs(sourceFile, jssc.hadoopConfiguration(), true);
        try {
            this.sourceSchema = new Schema.Parser().parse((InputStream)this.fs.open(new Path(sourceFile)));
            if (props.containsKey("hoodie.deltastreamer.schemaprovider.target.schema.file")) {
                this.targetSchema = new Schema.Parser().parse((InputStream)this.fs.open(new Path(props.getString("hoodie.deltastreamer.schemaprovider.target.schema.file"))));
            }
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error reading schema", ioe);
        }
    }

    @Override
    public Schema getSourceSchema() {
        return this.sourceSchema;
    }

    @Override
    public Schema getTargetSchema() {
        if (this.targetSchema != null) {
            return this.targetSchema;
        }
        return super.getTargetSchema();
    }

    public static class Config {
        private static final String SOURCE_SCHEMA_FILE_PROP = "hoodie.deltastreamer.schemaprovider.source.schema.file";
        private static final String TARGET_SCHEMA_FILE_PROP = "hoodie.deltastreamer.schemaprovider.target.schema.file";
    }
}

