/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class CreateTopicsRequestData
implements ApiMessage {
    private CreatableTopicCollection topics;
    private int timeoutMs;
    private boolean validateOnly;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("topics", new ArrayOf(CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;

    public CreateTopicsRequestData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public CreateTopicsRequestData(Struct struct, short _version) {
        this.fromStruct(struct, _version);
    }

    public CreateTopicsRequestData() {
        this.topics = new CreatableTopicCollection(0);
        this.timeoutMs = 60000;
        this.validateOnly = false;
    }

    @Override
    public short apiKey() {
        return 19;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        int i;
        CreatableTopicCollection newCollection;
        int arrayLength;
        if (_version >= 5) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version));
            }
            this.topics = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field topics was serialized as null");
            }
            newCollection = new CreatableTopicCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new CreatableTopic(_readable, _version));
            }
            this.topics = newCollection;
        }
        this.timeoutMs = _readable.readInt();
        this.validateOnly = _version >= 1 ? _readable.readByte() != 0 : false;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 5) {
            _writable.writeUnsignedVarint(this.topics.size() + 1);
            for (CreatableTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        } else {
            _writable.writeInt(this.topics.size());
            for (CreatableTopic topicsElement : this.topics) {
                topicsElement.write(_writable, _cache, _version);
            }
        }
        _writable.writeInt(this.timeoutMs);
        if (_version >= 1) {
            _writable.writeByte(this.validateOnly ? (byte)1 : 0);
        } else if (this.validateOnly) {
            throw new UnsupportedVersionException("Attempted to write a non-default validateOnly at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 5) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void fromStruct(Struct struct, short _version) {
        NavigableMap _taggedFields = null;
        this._unknownTaggedFields = null;
        if (_version >= 5) {
            _taggedFields = (NavigableMap)struct.get("_tagged_fields");
        }
        Object[] _nestedObjects = struct.getArray("topics");
        this.topics = new CreatableTopicCollection(_nestedObjects.length);
        for (Object nestedObject : _nestedObjects) {
            this.topics.add(new CreatableTopic((Struct)nestedObject, _version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
        this.validateOnly = _version >= 1 ? struct.getBoolean("validate_only") : false;
        if (_version >= 5 && !_taggedFields.isEmpty()) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
            for (Map.Entry entry : _taggedFields.entrySet()) {
                this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
            }
        }
    }

    @Override
    public Struct toStruct(short _version) {
        TreeMap _taggedFields = null;
        if (_version >= 5) {
            _taggedFields = new TreeMap();
        }
        Struct struct = new Struct(SCHEMAS[_version]);
        Struct[] _nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (CreatableTopic element : this.topics) {
            _nestedObjects[i++] = element.toStruct(_version);
        }
        struct.set("topics", (Object)_nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        if (_version >= 1) {
            struct.set("validate_only", (Object)this.validateOnly);
        }
        if (_version >= 5) {
            struct.set("_tagged_fields", _taggedFields);
        }
        return struct;
    }

    @Override
    public int size(ObjectSerializationCache _cache, short _version) {
        int _size = 0;
        int _numTaggedFields = 0;
        int _arraySize = 0;
        _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.topics.size() + 1)) : (_arraySize += 4);
        for (CreatableTopic topicsElement : this.topics) {
            _arraySize += topicsElement.size(_cache, _version);
        }
        _size += _arraySize;
        _size += 4;
        if (_version >= 1) {
            ++_size;
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                _size += _field.size();
            }
        }
        if (_version >= 5) {
            _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
        return _size;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CreateTopicsRequestData)) {
            return false;
        }
        CreateTopicsRequestData other = (CreateTopicsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        return this.validateOnly == other.validateOnly;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.validateOnly ? 1231 : 1237);
        return hashCode;
    }

    public String toString() {
        return "CreateTopicsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ", validateOnly=" + (this.validateOnly ? "true" : "false") + ")";
    }

    public CreatableTopicCollection topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public CreateTopicsRequestData setTopics(CreatableTopicCollection v) {
        this.topics = v;
        return this;
    }

    public CreateTopicsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public CreateTopicsRequestData setValidateOnly(boolean v) {
        this.validateOnly = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = new Schema(new Field("topics", new ArrayOf(CreatableTopic.SCHEMA_0), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."))));
        SCHEMA_5 = new Schema(new Field("topics", new CompactArrayOf(CreatableTopic.SCHEMA_5), "The topics to create."), new Field("timeout_ms", Type.INT32, "How long to wait in milliseconds before timing out the request."), new Field("validate_only", Type.BOOLEAN, "If true, check that the topics can be created as specified, but don't create anything."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class CreatableTopicCollection
    extends ImplicitLinkedHashMultiCollection<CreatableTopic> {
        public CreatableTopicCollection() {
        }

        public CreatableTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableTopicCollection(Iterator<CreatableTopic> iterator2) {
            super(iterator2);
        }

        @Override
        public CreatableTopic find(String name) {
            CreatableTopic key = new CreatableTopic();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<CreatableTopic> findAll(String name) {
            CreatableTopic key = new CreatableTopic();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class CreateableTopicConfigCollection
    extends ImplicitLinkedHashMultiCollection<CreateableTopicConfig> {
        public CreateableTopicConfigCollection() {
        }

        public CreateableTopicConfigCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreateableTopicConfigCollection(Iterator<CreateableTopicConfig> iterator2) {
            super(iterator2);
        }

        @Override
        public CreateableTopicConfig find(String name) {
            CreateableTopicConfig key = new CreateableTopicConfig();
            key.setName(name);
            return this.find(key);
        }

        @Override
        public List<CreateableTopicConfig> findAll(String name) {
            CreateableTopicConfig key = new CreateableTopicConfig();
            key.setName(name);
            return this.findAll(key);
        }
    }

    public static class CreateableTopicConfig
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private String value;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreateableTopicConfig(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreateableTopicConfig(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public CreateableTopicConfig() {
            this.name = "";
            this.value = "";
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreateableTopicConfig");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.value = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field value had invalid length " + length);
                }
                this.value = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreateableTopicConfig");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.value == null) {
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.value);
                if (_version >= 5) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreateableTopicConfig");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.value = struct.getString("value");
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreateableTopicConfig");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("value", (Object)this.value);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreateableTopicConfig");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            if (this.value == null) {
                _size = _version >= 5 ? ++_size : (_size += 2);
            } else {
                _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'value' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.value, _stringBytes);
                _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreateableTopicConfig)) {
                return false;
            }
            CreateableTopicConfig other = (CreateableTopicConfig)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreateableTopicConfig(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", value=" + (this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreateableTopicConfig setName(String v) {
            this.name = v;
            return this;
        }

        public CreateableTopicConfig setValue(String v) {
            this.value = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The configuration name."), new Field("value", Type.NULLABLE_STRING, "The configuration value.")))));
            SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The configuration name."), new Field("value", Type.COMPACT_NULLABLE_STRING, "The configuration value."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class CreatableReplicaAssignmentCollection
    extends ImplicitLinkedHashMultiCollection<CreatableReplicaAssignment> {
        public CreatableReplicaAssignmentCollection() {
        }

        public CreatableReplicaAssignmentCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public CreatableReplicaAssignmentCollection(Iterator<CreatableReplicaAssignment> iterator2) {
            super(iterator2);
        }

        @Override
        public CreatableReplicaAssignment find(int partitionIndex) {
            CreatableReplicaAssignment key = new CreatableReplicaAssignment();
            key.setPartitionIndex(partitionIndex);
            return this.find(key);
        }

        @Override
        public List<CreatableReplicaAssignment> findAll(int partitionIndex) {
            CreatableReplicaAssignment key = new CreatableReplicaAssignment();
            key.setPartitionIndex(partitionIndex);
            return this.findAll(key);
        }
    }

    public static class CreatableReplicaAssignment
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private int partitionIndex;
        private List<Integer> brokerIds;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreatableReplicaAssignment(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatableReplicaAssignment(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public CreatableReplicaAssignment() {
            this.partitionIndex = 0;
            this.brokerIds = new ArrayList<Integer>();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableReplicaAssignment");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field brokerIds was serialized as null");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.brokerIds = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableReplicaAssignment");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.brokerIds.size() + 1);
            } else {
                _writable.writeInt(this.brokerIds.size());
            }
            for (Integer brokerIdsElement : this.brokerIds) {
                _writable.writeInt(brokerIdsElement);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableReplicaAssignment");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.partitionIndex = struct.getInt("partition_index");
            Object[] _nestedObjects = struct.getArray("broker_ids");
            this.brokerIds = new ArrayList<Integer>(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.brokerIds.add((Integer)nestedObject);
            }
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableReplicaAssignment");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            Integer[] _nestedObjects = new Integer[this.brokerIds.size()];
            int i = 0;
            for (Integer element : this.brokerIds) {
                _nestedObjects[i++] = element;
            }
            struct.set("broker_ids", (Object)_nestedObjects);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableReplicaAssignment");
            }
            _size += 4;
            int _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.brokerIds.size() + 1)) : (_arraySize += 4);
            _size += (_arraySize += this.brokerIds.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableReplicaAssignment)) {
                return false;
            }
            CreatableReplicaAssignment other = (CreatableReplicaAssignment)obj;
            return this.partitionIndex == other.partitionIndex;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            return hashCode;
        }

        public String toString() {
            return "CreatableReplicaAssignment(partitionIndex=" + this.partitionIndex + ", brokerIds=" + MessageUtil.deepToString(this.brokerIds.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<Integer> brokerIds() {
            return this.brokerIds;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableReplicaAssignment setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public CreatableReplicaAssignment setBrokerIds(List<Integer> v) {
            this.brokerIds = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("broker_ids", new ArrayOf(Type.INT32), "The brokers to place the partition on.")))));
            SCHEMA_5 = new Schema(new Field("partition_index", Type.INT32, "The partition index."), new Field("broker_ids", new CompactArrayOf(Type.INT32), "The brokers to place the partition on."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }

    public static class CreatableTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        private String name;
        private int numPartitions;
        private short replicationFactor;
        private CreatableReplicaAssignmentCollection assignments;
        private CreateableTopicConfigCollection configs;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;

        public CreatableTopic(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public CreatableTopic(Struct struct, short _version) {
            this.fromStruct(struct, _version);
        }

        public CreatableTopic() {
            this.name = "";
            this.numPartitions = 0;
            this.replicationFactor = 0;
            this.assignments = new CreatableReplicaAssignmentCollection(0);
            this.configs = new CreateableTopicConfigCollection(0);
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            int i;
            ImplicitLinkedHashMultiCollection newCollection;
            int arrayLength;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopic");
            }
            int length = _version >= 5 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _readable.readString(length);
            this.numPartitions = _readable.readInt();
            this.replicationFactor = _readable.readShort();
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreatableReplicaAssignment(_readable, _version));
                }
                this.assignments = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field assignments was serialized as null");
                }
                newCollection = new CreatableReplicaAssignmentCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreatableReplicaAssignment(_readable, _version));
                }
                this.assignments = newCollection;
            }
            if (_version >= 5) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreateableTopicConfig(_readable, _version));
                }
                this.configs = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field configs was serialized as null");
                }
                newCollection = new CreateableTopicConfigCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new CreateableTopicConfig(_readable, _version));
                }
                this.configs = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            CreatableReplicaAssignment assignmentsElement;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopic");
            }
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeInt(this.numPartitions);
            _writable.writeShort(this.replicationFactor);
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.assignments.size() + 1);
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.assignments.size());
                _stringBytes = this.assignments.iterator();
                while (_stringBytes.hasNext()) {
                    assignmentsElement = (CreatableReplicaAssignment)_stringBytes.next();
                    assignmentsElement.write(_writable, _cache, _version);
                }
            }
            if (_version >= 5) {
                _writable.writeUnsignedVarint(this.configs.size() + 1);
                for (CreateableTopicConfig configsElement : this.configs) {
                    configsElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.configs.size());
                for (CreateableTopicConfig configsElement : this.configs) {
                    configsElement.write(_writable, _cache, _version);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 5) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void fromStruct(Struct struct, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopic");
            }
            NavigableMap _taggedFields = null;
            this._unknownTaggedFields = null;
            if (_version >= 5) {
                _taggedFields = (NavigableMap)struct.get("_tagged_fields");
            }
            this.name = struct.getString("name");
            this.numPartitions = struct.getInt("num_partitions");
            this.replicationFactor = struct.getShort("replication_factor");
            Object[] _nestedObjects = struct.getArray("assignments");
            this.assignments = new CreatableReplicaAssignmentCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.assignments.add(new CreatableReplicaAssignment((Struct)nestedObject, _version));
            }
            _nestedObjects = struct.getArray("configs");
            this.configs = new CreateableTopicConfigCollection(_nestedObjects.length);
            for (Object nestedObject : _nestedObjects) {
                this.configs.add(new CreateableTopicConfig((Struct)nestedObject, _version));
            }
            if (_version >= 5 && !_taggedFields.isEmpty()) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(_taggedFields.size());
                for (Map.Entry entry : _taggedFields.entrySet()) {
                    this._unknownTaggedFields.add((RawTaggedField)entry.getValue());
                }
            }
        }

        @Override
        public Struct toStruct(short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopic");
            }
            TreeMap _taggedFields = null;
            if (_version >= 5) {
                _taggedFields = new TreeMap();
            }
            Struct struct = new Struct(SCHEMAS[_version]);
            struct.set("name", (Object)this.name);
            struct.set("num_partitions", (Object)this.numPartitions);
            struct.set("replication_factor", (Object)this.replicationFactor);
            Struct[] _nestedObjects = new Struct[this.assignments.size()];
            int i = 0;
            for (Message element : this.assignments) {
                _nestedObjects[i++] = ((CreatableReplicaAssignment)element).toStruct(_version);
            }
            struct.set("assignments", (Object)_nestedObjects);
            _nestedObjects = new Struct[this.configs.size()];
            i = 0;
            for (Message element : this.configs) {
                _nestedObjects[i++] = ((CreateableTopicConfig)element).toStruct(_version);
            }
            struct.set("configs", (Object)_nestedObjects);
            if (_version >= 5) {
                struct.set("_tagged_fields", _taggedFields);
            }
            return struct;
        }

        @Override
        public int size(ObjectSerializationCache _cache, short _version) {
            int _size = 0;
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of CreatableTopic");
            }
            byte[] _stringBytes = this.name.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            _size = _version >= 5 ? (_size += _stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1)) : (_size += _stringBytes.length + 2);
            _size += 4;
            _size += 2;
            int _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.assignments.size() + 1)) : (_arraySize += 4);
            for (CreatableReplicaAssignment assignmentsElement : this.assignments) {
                _arraySize += assignmentsElement.size(_cache, _version);
            }
            _size += _arraySize;
            _arraySize = 0;
            _arraySize = _version >= 5 ? (_arraySize += ByteUtils.sizeOfUnsignedVarint(this.configs.size() + 1)) : (_arraySize += 4);
            for (CreateableTopicConfig configsElement : this.configs) {
                _arraySize += configsElement.size(_cache, _version);
            }
            _size += _arraySize;
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.tag());
                    _size += ByteUtils.sizeOfUnsignedVarint(_field.size());
                    _size += _field.size();
                }
            }
            if (_version >= 5) {
                _size += ByteUtils.sizeOfUnsignedVarint(_numTaggedFields);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
            return _size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CreatableTopic)) {
                return false;
            }
            CreatableTopic other = (CreatableTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public String toString() {
            return "CreatableTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", numPartitions=" + this.numPartitions + ", replicationFactor=" + this.replicationFactor + ", assignments=" + MessageUtil.deepToString(this.assignments.iterator()) + ", configs=" + MessageUtil.deepToString(this.configs.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public int numPartitions() {
            return this.numPartitions;
        }

        public short replicationFactor() {
            return this.replicationFactor;
        }

        public CreatableReplicaAssignmentCollection assignments() {
            return this.assignments;
        }

        public CreateableTopicConfigCollection configs() {
            return this.configs;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public CreatableTopic setName(String v) {
            this.name = v;
            return this;
        }

        public CreatableTopic setNumPartitions(int v) {
            this.numPartitions = v;
            return this;
        }

        public CreatableTopic setReplicationFactor(short v) {
            this.replicationFactor = v;
            return this;
        }

        public CreatableTopic setAssignments(CreatableReplicaAssignmentCollection v) {
            this.assignments = v;
            return this;
        }

        public CreatableTopic setConfigs(CreateableTopicConfigCollection v) {
            this.configs = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name."), new Field("num_partitions", Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", new ArrayOf(CreatableReplicaAssignment.SCHEMA_0), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", new ArrayOf(CreateableTopicConfig.SCHEMA_0), "The custom topic configurations to set.")))));
            SCHEMA_5 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name."), new Field("num_partitions", Type.INT32, "The number of partitions to create in the topic, or -1 if we are either specifying a manual partition assignment or using the default partitions."), new Field("replication_factor", Type.INT16, "The number of replicas to create for each partition in the topic, or -1 if we are either specifying a manual partition assignment or using the default replication factor."), new Field("assignments", new CompactArrayOf(CreatableReplicaAssignment.SCHEMA_5), "The manual partition assignment, or the empty array if we are using automatic assignment."), new Field("configs", new CompactArrayOf(CreateableTopicConfig.SCHEMA_5), "The custom topic configurations to set."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

