/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi;

import java.io.Serializable;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.DFSPropertiesConfiguration;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.package$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.AliasIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.MergeIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.SubqueryAlias;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HoodieSqlUtils$
implements SparkAdapterSupport {
    public static HoodieSqlUtils$ MODULE$;
    private Set<String> metaFields;
    private final ThreadLocal<SimpleDateFormat> defaultDateFormat;
    private SparkAdapter sparkAdapter;
    private volatile byte bitmap$0;

    static {
        new HoodieSqlUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSqlUtils$ hoodieSqlUtils$ = this;
        synchronized (hoodieSqlUtils$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.sparkAdapter;
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.sparkAdapter$lzycompute() : this.sparkAdapter;
    }

    private ThreadLocal<SimpleDateFormat> defaultDateFormat() {
        return this.defaultDateFormat;
    }

    public boolean isHoodieTable(CatalogTable table) {
        Object object = table.provider().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toLowerCase(Locale.ROOT)).orNull(Predef$.MODULE$.$conforms());
        String string = "hudi";
        return !(object != null ? !object.equals(string) : string != null);
    }

    public boolean isHoodieTable(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.isHoodieTable(table);
    }

    public boolean isHoodieTable(LogicalPlan table, SparkSession spark) {
        boolean bl;
        LogicalRelation logicalRelation;
        Option option;
        LogicalPlan logicalPlan = this.tripAlias(table);
        if (logicalPlan instanceof LogicalRelation && (option = (logicalRelation = (LogicalRelation)logicalPlan).catalogTable()) instanceof Some) {
            Some some = (Some)option;
            CatalogTable tbl = (CatalogTable)some.value();
            bl = this.isHoodieTable(tbl);
        } else if (logicalPlan instanceof UnresolvedRelation) {
            UnresolvedRelation unresolvedRelation = (UnresolvedRelation)logicalPlan;
            bl = this.isHoodieTable(this.sparkAdapter().toTableIdentify(unresolvedRelation), spark);
        } else {
            bl = false;
        }
        return bl;
    }

    public TableIdentifier getTableIdentify(LogicalPlan table) {
        LogicalPlan logicalPlan = table;
        if (!(logicalPlan instanceof SubqueryAlias)) {
            throw new IllegalArgumentException(new StringBuilder(15).append("Illegal table: ").append(table).toString());
        }
        SubqueryAlias subqueryAlias = (SubqueryAlias)logicalPlan;
        AliasIdentifier name = subqueryAlias.identifier();
        TableIdentifier tableIdentifier = this.sparkAdapter().toTableIdentify(name);
        return tableIdentifier;
    }

    public Option<StructType> getTableSqlSchema(HoodieTableMetaClient metaClient, boolean includeMetadataFields) {
        Some some;
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            some = new Some((Object)schemaResolver.getTableAvroSchema(includeMetadataFields));
        }
        catch (Throwable throwable) {
            some = None$.MODULE$;
        }
        Some avroSchema2 = some;
        return avroSchema2.map((Function1 & Serializable & scala.Serializable)avroSchema -> AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType((Schema)avroSchema));
    }

    public boolean getTableSqlSchema$default$2() {
        return false;
    }

    public Seq<String> getAllPartitionPaths(SparkSession spark, CatalogTable table) {
        HoodieSparkEngineContext sparkEngine = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        Properties properties = new Properties();
        properties.putAll((java.util.Map<?, ?>)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)spark.sessionState().conf().getAllConfs().$plus$plus((GenTraversableOnce)table.storage().properties()).$plus$plus((GenTraversableOnce)table.properties())).asJava()));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(properties).build();
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter(FSUtils.getAllPartitionPaths(sparkEngine, metadataConfig, this.getTableLocation(table, spark))).asScala();
    }

    public boolean isHiveStyledPartitioning(Seq<String> partitionPaths, CatalogTable table) {
        boolean bl;
        if (table.partitionColumnNames().nonEmpty()) {
            Function1 & Serializable & scala.Serializable isHiveStylePartitionPath = (Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.$anonfun$isHiveStyledPartitioning$1(table, path));
            bl = partitionPaths.forall((Function1)isHiveStylePartitionPath);
        } else {
            bl = true;
        }
        return bl;
    }

    public boolean isUrlEncodeEnabled(Seq<String> partitionPaths, CatalogTable table) {
        return table.partitionColumnNames().nonEmpty() ? partitionPaths.forall((Function1 & Serializable & scala.Serializable)partitionPath -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.$anonfun$isUrlEncodeEnabled$1(table, partitionPath))) : false;
    }

    private LogicalPlan tripAlias(LogicalPlan plan) {
        SubqueryAlias subqueryAlias;
        LogicalPlan relation;
        LogicalPlan logicalPlan;
        while ((logicalPlan = plan) instanceof SubqueryAlias && (relation = (subqueryAlias = (SubqueryAlias)logicalPlan).child()) != null) {
            LogicalPlan logicalPlan2;
            plan = logicalPlan2 = relation;
        }
        LogicalPlan logicalPlan3 = logicalPlan;
        return logicalPlan3;
    }

    public StructType addMetaFields(StructType schema) {
        Buffer metaFields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala();
        StructField[] dataFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)metaFields.contains((Object)f.name())));
        Buffer fields = ((BufferLike)metaFields.map((Function1 & Serializable & scala.Serializable)x$2 -> new StructField(x$2, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFields)));
        return StructType$.MODULE$.apply((Seq)fields);
    }

    private Set<String> metaFields$lzycompute() {
        HoodieSqlUtils$ hoodieSqlUtils$ = this;
        synchronized (hoodieSqlUtils$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.metaFields = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).toSet();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.metaFields;
    }

    private Set<String> metaFields() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.metaFields$lzycompute() : this.metaFields;
    }

    public StructType removeMetaFields(StructType schema) {
        return new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.MODULE$.isMetaField(f.name()))));
    }

    public boolean isMetaField(String name) {
        return this.metaFields().contains((Object)name);
    }

    public Dataset<Row> removeMetaFields(Dataset<Row> df) {
        Seq withoutMetaColumns = (Seq)((TraversableLike)df.logicalPlan().output().filterNot((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.MODULE$.isMetaField(attr.name())))).map((Function1 & Serializable & scala.Serializable)x$3 -> new Column((Expression)x$3), Seq$.MODULE$.canBuildFrom());
        return withoutMetaColumns.length() != df.logicalPlan().output().size() ? df.select(withoutMetaColumns) : df;
    }

    public Seq<Attribute> removeMetaFields(Seq<Attribute> attrs) {
        return (Seq)attrs.filterNot((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.MODULE$.isMetaField(attr.name())));
    }

    public String getTableLocation(TableIdentifier tableId, SparkSession spark) {
        CatalogTable table = spark.sessionState().catalog().getTableMetadata(tableId);
        return this.getTableLocation(table, spark);
    }

    public String getTableLocation(CatalogTable table, SparkSession sparkSession) {
        CatalogTableType catalogTableType = table.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.MANAGED();
        Option uri = !(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null) && this.isHoodieTable(table) ? new Some((Object)sparkSession.sessionState().catalog().defaultTablePath(table.identifier())) : table.storage().locationUri();
        Configuration conf = sparkSession.sessionState().newHadoopConf();
        return (String)uri.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.makePathQualified((URI)x$4, conf)).map((Function1 & Serializable & scala.Serializable)path -> MODULE$.removePlaceHolder((String)path)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(21).append("Missing location for ").append(table.identifier()).toString());
        });
    }

    private String removePlaceHolder(String path) {
        return path == null || path.length() == 0 ? path : (path.endsWith("-__PLACEHOLDER__") ? path.substring(0, path.length() - 16) : path);
    }

    public String makePathQualified(URI path, Configuration hadoopConf) {
        Path hadoopPath = new Path(path);
        FileSystem fs = hadoopPath.getFileSystem(hadoopConf);
        return fs.makeQualified(hadoopPath).toUri().toString();
    }

    public boolean tableExistsInPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        Path metaPath = new Path(basePath, ".hoodie");
        return fs.exists(metaPath);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression castIfNeeded(Expression child, DataType dataType, SQLConf conf) {
        Expression expression = child;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object nul = literal.value();
            DataType dataType2 = literal.dataType();
            if (NullType$.MODULE$.equals(dataType2)) {
                return new Literal(nul, dataType);
            }
        }
        DataType dataType3 = child.dataType();
        DataType dataType4 = dataType;
        return (dataType3 == null ? dataType4 != null : !dataType3.equals(dataType4)) ? new Cast(child, dataType, Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone())) : child;
    }

    /*
     * Unable to fully structure code
     */
    public TableIdentifier getMergeIntoTargetTableId(MergeIntoTable mergeInto) {
        var4_2 = false;
        var5_3 = null;
        var6_4 = mergeInto.targetTable();
        if (!(var6_4 instanceof SubqueryAlias)) ** GOTO lbl-1000
        var4_2 = true;
        var5_3 = (SubqueryAlias)var6_4;
        var7_5 = var5_3.child();
        if (var7_5 instanceof SubqueryAlias) {
            var8_6 = (SubqueryAlias)var7_5;
            var2_8 = tableId = var8_6.identifier();
        } else if (var4_2) {
            var2_8 = tableId = var5_3.identifier();
        } else {
            throw new IllegalArgumentException(new StringBuilder(23).append("Illegal plan ").append(var6_4).append(" in target").toString());
        }
        aliaId = var2_8;
        return this.sparkAdapter().toTableIdentify(aliaId);
    }

    public Seq<Expression> splitByAnd(Expression expression) {
        Seq seq;
        Expression expression2 = expression;
        if (expression2 instanceof And) {
            And and = (And)expression2;
            Expression left = and.left();
            Expression right = and.right();
            seq = (Seq)this.splitByAnd(left).$plus$plus(this.splitByAnd(right), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{expression2}));
        }
        return seq;
    }

    public scala.collection.immutable.Map<String, String> withSparkConf(SparkSession spark, scala.collection.immutable.Map<String, String> options, scala.collection.immutable.Map<String, String> baseConfig) {
        return baseConfig.$plus$plus((GenTraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)DFSPropertiesConfiguration.getGlobalProps()).asScala()).$plus$plus((GenTraversableOnce)spark.sessionState().conf().getAllConfs().$plus$plus(HoodieOptionConfig$.MODULE$.mappingSqlOptionToHoodieParam(options)).filterKeys((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.startsWith("hoodie."))));
    }

    public scala.collection.immutable.Map<String, String> withSparkConf$default$3(SparkSession spark, scala.collection.immutable.Map<String, String> options) {
        return Map$.MODULE$.empty();
    }

    public boolean isSpark3() {
        return package$.MODULE$.SPARK_VERSION().startsWith("3.");
    }

    public boolean isEnableHive(SparkSession sparkSession) {
        return "hive".equals(sparkSession.sessionState().conf().getConf(StaticSQLConf$.MODULE$.CATALOG_IMPLEMENTATION()));
    }

    public String formatQueryInstant(String queryInstant) {
        String string;
        int instantLength = queryInstant.length();
        if (instantLength == 19 || instantLength == 23) {
            string = HoodieInstantTimeGenerator.getInstantForDateString(queryInstant);
        } else if (instantLength == HoodieInstantTimeGenerator.SECS_INSTANT_ID_LENGTH || instantLength == HoodieInstantTimeGenerator.MILLIS_INSTANT_ID_LENGTH) {
            HoodieActiveTimeline.parseDateFromInstantTime(queryInstant);
            string = queryInstant;
        } else if (instantLength == 10) {
            string = HoodieActiveTimeline.formatDate(((DateFormat)this.defaultDateFormat().get()).parse(queryInstant));
        } else {
            throw new IllegalArgumentException(new StringBuilder(132).append("Unsupported query instant time format: ").append(queryInstant).append(",").append("Supported time format are: 'yyyy-MM-dd: HH:mm:ss.SSS' or 'yyyy-MM-dd' or 'yyyyMMddHHmmssSSS'").toString());
        }
        return string;
    }

    public String formatName(SparkSession sparkSession, String name) {
        return sparkSession.sessionState().conf().caseSensitiveAnalysis() ? name : name.toLowerCase(Locale.ROOT);
    }

    public boolean isEmptyPath(String tablePath, Configuration conf) {
        Path basePath = new Path(tablePath);
        FileSystem fs = basePath.getFileSystem(conf);
        return fs.exists(basePath) ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(basePath))).isEmpty() : true;
    }

    public static final /* synthetic */ boolean $anonfun$isHiveStyledPartitioning$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String pathFragment = (String)tuple2._1();
        String partitionColumn = (String)tuple2._2();
        boolean bl = pathFragment.startsWith(new StringBuilder(1).append(partitionColumn).append("=").toString());
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isHiveStyledPartitioning$1(CatalogTable table$1, String path) {
        String[] fragments = path.split("/");
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fragments)).size() != table$1.partitionColumnNames().size() ? false : new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fragments)).zip((GenIterable)table$1.partitionColumnNames(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HoodieSqlUtils$.$anonfun$isHiveStyledPartitioning$2(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$isUrlEncodeEnabled$1(CatalogTable table$2, String partitionPath) {
        return partitionPath.split("/").length == table$2.partitionColumnNames().size();
    }

    private HoodieSqlUtils$() {
        MODULE$ = this;
        SparkAdapterSupport.$init$(this);
        this.defaultDateFormat = ThreadLocal.withInitial(new Supplier<SimpleDateFormat>(){

            public SimpleDateFormat get() {
                return new SimpleDateFormat("yyyy-MM-dd");
            }
        });
    }
}

