/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.rmi.ssl.SslRMIServerSocketFactory;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SslRMIServerSocketFactorySecure
extends SslRMIServerSocketFactory {
    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port){

            @Override
            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocketFactory sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                sslSocket.setNeedClientAuth(false);
                ArrayList<String> secureProtocols = new ArrayList<String>();
                for (String p : sslSocket.getEnabledProtocols()) {
                    if (p.contains("SSLv3")) continue;
                    secureProtocols.add(p);
                }
                sslSocket.setEnabledProtocols(secureProtocols.toArray(new String[secureProtocols.size()]));
                return sslSocket;
            }
        };
    }
}

