/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.util.Map;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public interface UserMetrics {
    public byte[] getUserName();

    public long getReadRequestCount();

    public long getWriteRequestCount();

    default public long getRequestCount() {
        return this.getReadRequestCount() + this.getWriteRequestCount();
    }

    default public String getNameAsString() {
        return Bytes.toStringBinary(this.getUserName());
    }

    public Map<String, ClientMetrics> getClientMetrics();

    public long getFilteredReadRequests();

    public static interface ClientMetrics {
        public String getHostName();

        public long getReadRequestsCount();

        public long getWriteRequestsCount();

        public long getFilteredReadRequestsCount();
    }
}

