/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.Abortable;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.MasterAddressTracker;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import io.hops.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ZNodeClearer {
    private static final Logger LOG = LoggerFactory.getLogger(ZNodeClearer.class);

    private ZNodeClearer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeMyEphemeralNodeOnDisk(String fileContent) {
        FileWriter fstream;
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName == null) {
            LOG.warn("Environment variable HBASE_ZNODE_FILE not set; znodes will not be cleared on crash by start scripts (Longer MTTR!)");
            return;
        }
        try {
            fstream = new FileWriter(fileName);
        }
        catch (IOException e) {
            LOG.warn("Can't write znode file " + fileName, (Throwable)e);
            return;
        }
        BufferedWriter out = new BufferedWriter(fstream);
        try {
            try {
                out.write(fileContent + "\n");
            }
            finally {
                try {
                    out.close();
                }
                finally {
                    fstream.close();
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Can't write znode file " + fileName, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readMyEphemeralNodeOnDisk() throws IOException {
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName == null) {
            throw new FileNotFoundException("No filename; set environment variable HBASE_ZNODE_FILE");
        }
        FileReader znodeFile = new FileReader(fileName);
        try (BufferedReader br = null;){
            String file_content;
            br = new BufferedReader(znodeFile);
            String string = file_content = br.readLine();
            return string;
        }
    }

    public static String getMyEphemeralNodeFileName() {
        return System.getenv().get("HBASE_ZNODE_FILE");
    }

    public static void deleteMyEphemeralNodeOnDisk() {
        String fileName = ZNodeClearer.getMyEphemeralNodeFileName();
        if (fileName != null) {
            new File(fileName).delete();
        }
    }

    public static String parseMasterServerName(String rsZnodePath) {
        String masterServerName = null;
        try {
            String[] rsZnodeParts = rsZnodePath.split("/");
            masterServerName = rsZnodeParts[rsZnodeParts.length - 1];
        }
        catch (IndexOutOfBoundsException e) {
            LOG.warn("String " + rsZnodePath + " has wrong format", (Throwable)e);
        }
        return masterServerName;
    }

    @Deprecated
    private static boolean tablesOnMaster(Configuration conf) {
        boolean tablesOnMaster = true;
        String confValue = conf.get("hbase.balancer.tablesOnMaster");
        if (confValue != null && confValue.equalsIgnoreCase("none")) {
            tablesOnMaster = false;
        }
        return tablesOnMaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean clear(Configuration conf) {
        ZKWatcher zkw;
        Configuration tempConf = new Configuration(conf);
        tempConf.setInt("zookeeper.recovery.retry", 0);
        try {
            zkw = new ZKWatcher(tempConf, "clean znode for master", new Abortable(){

                @Override
                public void abort(String why, Throwable e) {
                }

                @Override
                public boolean isAborted() {
                    return false;
                }
            });
        }
        catch (IOException e) {
            LOG.warn("Can't connect to zookeeper to read the master znode", (Throwable)e);
            return false;
        }
        try {
            String znodeFileContent = ZNodeClearer.readMyEphemeralNodeOnDisk();
            if (ZNodeClearer.tablesOnMaster(conf)) {
                ZKUtil.deleteNodeFailSilent((ZKWatcher)zkw, (String)ZNodePaths.joinZNode(zkw.getZNodePaths().rsZNode, znodeFileContent));
                boolean bl = MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)ZNodeClearer.parseMasterServerName(znodeFileContent));
                return bl;
            }
            boolean bl = MasterAddressTracker.deleteIfEquals((ZKWatcher)zkw, (String)znodeFileContent);
            return bl;
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Can't find the znode file; presume non-fatal", (Throwable)fnfe);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LOG.warn("Can't read the content of the znode file", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        catch (KeeperException e) {
            LOG.warn("ZooKeeper exception deleting znode", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            zkw.close();
        }
    }
}

