/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.RegionLocations;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncRegionLocatorHelper;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionRegistry;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class AsyncMetaRegionLocator {
    private final ConnectionRegistry registry;
    private final AtomicReference<RegionLocations> metaRegionLocations = new AtomicReference();
    private final AtomicReference<CompletableFuture<RegionLocations>> metaRelocateFuture = new AtomicReference();

    AsyncMetaRegionLocator(ConnectionRegistry registry) {
        this.registry = registry;
    }

    CompletableFuture<RegionLocations> getRegionLocations(int replicaId, boolean reload) {
        return ConnectionUtils.getOrFetch(this.metaRegionLocations, this.metaRelocateFuture, reload, this.registry::getMetaRegionLocations, locs -> AsyncRegionLocatorHelper.isGood(locs, replicaId), "meta region location");
    }

    private HRegionLocation getCacheLocation(HRegionLocation loc) {
        RegionLocations locs = this.metaRegionLocations.get();
        return locs != null ? locs.getRegionLocation(loc.getRegion().getReplicaId()) : null;
    }

    private void addLocationToCache(HRegionLocation loc) {
        RegionLocations newLocs;
        RegionLocations oldLocs;
        do {
            RegionLocations newLocs2;
            int replicaId = loc.getRegion().getReplicaId();
            oldLocs = this.metaRegionLocations.get();
            if (oldLocs == null && this.metaRegionLocations.compareAndSet(null, newLocs2 = AsyncRegionLocatorHelper.createRegionLocations(loc))) {
                return;
            }
            HRegionLocation oldLoc = oldLocs.getRegionLocation(replicaId);
            if (oldLoc == null || oldLoc.getSeqNum() <= loc.getSeqNum() && !oldLoc.getServerName().equals(loc.getServerName())) continue;
            return;
        } while (!this.metaRegionLocations.compareAndSet(oldLocs, newLocs = AsyncRegionLocatorHelper.replaceRegionLocation(oldLocs, loc)));
    }

    private void removeLocationFromCache(HRegionLocation loc) {
        RegionLocations newLocs;
        RegionLocations oldLocs;
        do {
            if ((oldLocs = this.metaRegionLocations.get()) == null) {
                return;
            }
            HRegionLocation oldLoc = oldLocs.getRegionLocation(loc.getRegion().getReplicaId());
            if (AsyncRegionLocatorHelper.canUpdateOnError(loc, oldLoc)) continue;
            return;
        } while (!this.metaRegionLocations.compareAndSet(oldLocs, newLocs = AsyncRegionLocatorHelper.removeRegionLocation(oldLocs, loc.getRegion().getReplicaId())));
    }

    void updateCachedLocationOnError(HRegionLocation loc, Throwable exception) {
        AsyncRegionLocatorHelper.updateCachedLocationOnError(loc, exception, this::getCacheLocation, this::addLocationToCache, this::removeLocationFromCache, null);
    }

    void clearCache() {
        this.metaRegionLocations.set(null);
    }

    void clearCache(ServerName serverName) {
        RegionLocations newLocs;
        RegionLocations locs;
        do {
            if ((locs = this.metaRegionLocations.get()) == null) {
                return;
            }
            newLocs = locs.removeByServer(serverName);
            if (locs == newLocs) {
                return;
            }
            if (!newLocs.isEmpty()) continue;
            newLocs = null;
        } while (!this.metaRegionLocations.compareAndSet(locs, newLocs));
    }
}

