/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.CancellableRegionServerCallable;
import io.hops.hudi.org.apache.hadoop.hbase.client.Row;
import io.hops.hudi.org.apache.hadoop.hbase.client.RowAccess;
import io.hops.hudi.org.apache.hadoop.hbase.client.coprocessor.Batch;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class AsyncProcessTask<T> {
    private final ExecutorService pool;
    private final TableName tableName;
    private final RowAccess<? extends Row> rows;
    private final SubmittedRows submittedRows;
    private final Batch.Callback<T> callback;
    private final CancellableRegionServerCallable callable;
    private final boolean needResults;
    private final int rpcTimeout;
    private final int operationTimeout;
    private final Object[] results;

    public static <T> Builder<T> newBuilder(Batch.Callback<T> callback) {
        return new Builder(callback);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    AsyncProcessTask(AsyncProcessTask<T> task) {
        this(task.getPool(), task.getTableName(), task.getRowAccess(), task.getSubmittedRows(), task.getCallback(), task.getCallable(), task.getNeedResults(), task.getRpcTimeout(), task.getOperationTimeout(), task.getResults());
    }

    AsyncProcessTask(ExecutorService pool, TableName tableName, RowAccess<? extends Row> rows, SubmittedRows size, Batch.Callback<T> callback, CancellableRegionServerCallable callable, boolean needResults, int rpcTimeout, int operationTimeout, Object[] results) {
        this.pool = pool;
        this.tableName = tableName;
        this.rows = rows;
        this.submittedRows = size;
        this.callback = callback;
        this.callable = callable;
        this.needResults = needResults;
        this.rpcTimeout = rpcTimeout;
        this.operationTimeout = operationTimeout;
        this.results = results;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    public ExecutorService getPool() {
        return this.pool;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public RowAccess<? extends Row> getRowAccess() {
        return this.rows;
    }

    public SubmittedRows getSubmittedRows() {
        return this.submittedRows;
    }

    public Batch.Callback<T> getCallback() {
        return this.callback;
    }

    CancellableRegionServerCallable getCallable() {
        return this.callable;
    }

    Object[] getResults() {
        return this.results;
    }

    public boolean getNeedResults() {
        return this.needResults;
    }

    public int getRpcTimeout() {
        return this.rpcTimeout;
    }

    static class ListRowAccess<T>
    implements RowAccess<T> {
        private final List<T> data;

        ListRowAccess(List<T> data) {
            this.data = data;
        }

        @Override
        public int size() {
            return this.data.size();
        }

        @Override
        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.data.iterator();
        }
    }

    public static class Builder<T> {
        private ExecutorService pool;
        private TableName tableName;
        private RowAccess<? extends Row> rows;
        private SubmittedRows submittedRows = SubmittedRows.ALL;
        private Batch.Callback<T> callback;
        private boolean needResults;
        private int rpcTimeout;
        private int operationTimeout;
        private CancellableRegionServerCallable callable;
        private Object[] results;

        private Builder() {
        }

        private Builder(Batch.Callback<T> callback) {
            this.callback = callback;
        }

        Builder<T> setResults(Object[] results) {
            this.results = results;
            if (results != null && results.length != 0) {
                this.setNeedResults(true);
            }
            return this;
        }

        public Builder<T> setPool(ExecutorService pool) {
            this.pool = pool;
            return this;
        }

        public Builder<T> setRpcTimeout(int rpcTimeout) {
            this.rpcTimeout = rpcTimeout;
            return this;
        }

        public Builder<T> setOperationTimeout(int operationTimeout) {
            this.operationTimeout = operationTimeout;
            return this;
        }

        public Builder<T> setTableName(TableName tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder<T> setRowAccess(List<? extends Row> rows) {
            this.rows = new ListRowAccess<Row>(rows);
            return this;
        }

        public Builder<T> setRowAccess(RowAccess<? extends Row> rows) {
            this.rows = rows;
            return this;
        }

        public Builder<T> setSubmittedRows(SubmittedRows submittedRows) {
            this.submittedRows = submittedRows;
            return this;
        }

        public Builder<T> setNeedResults(boolean needResults) {
            this.needResults = needResults;
            return this;
        }

        Builder<T> setCallable(CancellableRegionServerCallable callable) {
            this.callable = callable;
            return this;
        }

        public AsyncProcessTask<T> build() {
            return new AsyncProcessTask<T>(this.pool, this.tableName, this.rows, this.submittedRows, this.callback, this.callable, this.needResults, this.rpcTimeout, this.operationTimeout, this.results);
        }
    }

    public static enum SubmittedRows {
        ALL,
        AT_LEAST_ONE,
        NORMAL;

    }
}

