/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncRpcRetryingCallerFactory;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MasterCoprocessorRpcChannelImpl
implements RpcChannel {
    AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<Message> callerBuilder;

    MasterCoprocessorRpcChannelImpl(AsyncRpcRetryingCallerFactory.MasterRequestCallerBuilder<Message> callerBuilder) {
        this.callerBuilder = callerBuilder;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method, Message request, final Message responsePrototype, final HBaseRpcController controller, MasterProtos.MasterService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request);
        stub.execMasterService(controller, csr, new RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            @Override
            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, com.google.protobuf.RpcCallback<Message> done) {
        FutureUtils.addListener(this.callerBuilder.action((c, s) -> this.rpcCall(method, request, responsePrototype, c, s)).call(), (r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run(r);
        });
    }
}

