/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcChannel;
import com.google.protobuf.RpcController;
import io.hops.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import io.hops.hudi.org.apache.hadoop.hbase.client.ClientCoprocessorRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionLocateType;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.RpcCallback;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionCoprocessorRpcChannelImpl
implements RpcChannel {
    private final AsyncConnectionImpl conn;
    private final TableName tableName;
    private final RegionInfo region;
    private final byte[] row;
    private final long rpcTimeoutNs;
    private final long operationTimeoutNs;

    RegionCoprocessorRpcChannelImpl(AsyncConnectionImpl conn, TableName tableName, RegionInfo region, byte[] row, long rpcTimeoutNs, long operationTimeoutNs) {
        this.conn = conn;
        this.tableName = tableName;
        this.region = region;
        this.row = row;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.operationTimeoutNs = operationTimeoutNs;
    }

    private CompletableFuture<Message> rpcCall(Descriptors.MethodDescriptor method, Message request, final Message responsePrototype, final HBaseRpcController controller, HRegionLocation loc, ClientProtos.ClientService.Interface stub) {
        final CompletableFuture<Message> future = new CompletableFuture<Message>();
        if (this.region != null && !Bytes.equals(loc.getRegionInfo().getRegionName(), this.region.getRegionName())) {
            future.completeExceptionally(new DoNotRetryIOException("Region name is changed, expected " + this.region.getRegionNameAsString() + ", actual " + loc.getRegionInfo().getRegionNameAsString()));
            return future;
        }
        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, this.row, loc.getRegionInfo().getRegionName());
        stub.execService(controller, csr, new RpcCallback<ClientProtos.CoprocessorServiceResponse>(){

            @Override
            public void run(ClientProtos.CoprocessorServiceResponse resp) {
                if (controller.failed()) {
                    future.completeExceptionally(controller.getFailed());
                } else {
                    try {
                        future.complete(CoprocessorRpcUtils.getResponse(resp, responsePrototype));
                    }
                    catch (IOException e) {
                        future.completeExceptionally(e);
                    }
                }
            }
        });
        return future;
    }

    public void callMethod(Descriptors.MethodDescriptor method, RpcController controller, Message request, Message responsePrototype, com.google.protobuf.RpcCallback<Message> done) {
        FutureUtils.addListener(this.conn.callerFactory.single().table(this.tableName).row(this.row).locateType(RegionLocateType.CURRENT).rpcTimeout(this.rpcTimeoutNs, TimeUnit.NANOSECONDS).operationTimeout(this.operationTimeoutNs, TimeUnit.NANOSECONDS).action((c, l, s) -> this.rpcCall(method, request, responsePrototype, c, l, s)).call(), (r, e) -> {
            if (e != null) {
                ((ClientCoprocessorRpcController)controller).setFailed((Throwable)e);
            }
            done.run(r);
        });
    }
}

