/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.codec;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.CellBuilderType;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCellBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCellBuilderFactory;
import io.hops.hudi.org.apache.hadoop.hbase.codec.BaseDecoder;
import io.hops.hudi.org.apache.hadoop.hbase.codec.BaseEncoder;
import io.hops.hudi.org.apache.hadoop.hbase.codec.Codec;
import io.hops.hudi.org.apache.hadoop.hbase.io.ByteBuffInputStream;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.CellProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class MessageCodec
implements Codec {
    @Override
    public Codec.Decoder getDecoder(InputStream is) {
        return new MessageDecoder(is);
    }

    @Override
    public Codec.Decoder getDecoder(ByteBuff buf) {
        return this.getDecoder(new ByteBuffInputStream(buf));
    }

    @Override
    public Codec.Encoder getEncoder(OutputStream os) {
        return new MessageEncoder(os);
    }

    static class MessageDecoder
    extends BaseDecoder {
        private final ExtendedCellBuilder cellBuilder = ExtendedCellBuilderFactory.create(CellBuilderType.SHALLOW_COPY);

        MessageDecoder(InputStream in) {
            super(in);
        }

        @Override
        protected Cell parseCell() throws IOException {
            return ProtobufUtil.toCell(this.cellBuilder, CellProtos.Cell.parseDelimitedFrom(this.in), false);
        }
    }

    static class MessageEncoder
    extends BaseEncoder {
        MessageEncoder(OutputStream out) {
            super(out);
        }

        @Override
        public void write(Cell cell) throws IOException {
            this.checkFlushed();
            CellProtos.Cell.Builder builder = CellProtos.Cell.newBuilder();
            builder.setRow(UnsafeByteOperations.unsafeWrap(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength()));
            builder.setFamily(UnsafeByteOperations.unsafeWrap(cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength()));
            builder.setQualifier(UnsafeByteOperations.unsafeWrap(cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength()));
            builder.setTimestamp(cell.getTimestamp());
            builder.setCellType(CellProtos.CellType.valueOf(cell.getTypeByte()));
            builder.setValue(UnsafeByteOperations.unsafeWrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
            CellProtos.Cell pbcell = builder.build();
            pbcell.writeDelimitedTo(this.out);
        }
    }
}

