/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile;

import io.hops.hudi.org.apache.hadoop.hbase.io.ByteBuffAllocator;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.ExclusiveMemHFileBlock;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.SharedMemHFileBlock;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileBlockBuilder {
    private BlockType blockType;
    private int onDiskSizeWithoutHeader;
    private int onDiskDataSizeWithHeader;
    private int uncompressedSizeWithoutHeader;
    private long prevBlockOffset;
    private ByteBuff buf;
    private boolean fillHeader = false;
    private long offset = Integer.MIN_VALUE;
    private int nextBlockOnDiskSize = Integer.MIN_VALUE;
    private HFileContext fileContext;
    private ByteBuffAllocator allocator = ByteBuffAllocator.HEAP;
    private boolean isShared;

    public HFileBlockBuilder withBlockType(BlockType blockType) {
        this.blockType = blockType;
        return this;
    }

    public HFileBlockBuilder withOnDiskSizeWithoutHeader(int onDiskSizeWithoutHeader) {
        this.onDiskSizeWithoutHeader = onDiskSizeWithoutHeader;
        return this;
    }

    public HFileBlockBuilder withOnDiskDataSizeWithHeader(int onDiskDataSizeWithHeader) {
        this.onDiskDataSizeWithHeader = onDiskDataSizeWithHeader;
        return this;
    }

    public HFileBlockBuilder withUncompressedSizeWithoutHeader(int uncompressedSizeWithoutHeader) {
        this.uncompressedSizeWithoutHeader = uncompressedSizeWithoutHeader;
        return this;
    }

    public HFileBlockBuilder withPrevBlockOffset(long prevBlockOffset) {
        this.prevBlockOffset = prevBlockOffset;
        return this;
    }

    public HFileBlockBuilder withByteBuff(ByteBuff buf) {
        this.buf = buf;
        return this;
    }

    public HFileBlockBuilder withFillHeader(boolean fillHeader) {
        this.fillHeader = fillHeader;
        return this;
    }

    public HFileBlockBuilder withOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public HFileBlockBuilder withNextBlockOnDiskSize(int nextBlockOnDiskSize) {
        this.nextBlockOnDiskSize = nextBlockOnDiskSize;
        return this;
    }

    public HFileBlockBuilder withHFileContext(HFileContext fileContext) {
        this.fileContext = fileContext;
        return this;
    }

    public HFileBlockBuilder withByteBuffAllocator(ByteBuffAllocator allocator) {
        this.allocator = allocator;
        return this;
    }

    public HFileBlockBuilder withShared(boolean isShared) {
        this.isShared = isShared;
        return this;
    }

    public HFileBlock build() {
        if (this.isShared) {
            return new SharedMemHFileBlock(this.blockType, this.onDiskSizeWithoutHeader, this.uncompressedSizeWithoutHeader, this.prevBlockOffset, this.buf, this.fillHeader, this.offset, this.nextBlockOnDiskSize, this.onDiskDataSizeWithHeader, this.fileContext, this.allocator);
        }
        return new ExclusiveMemHFileBlock(this.blockType, this.onDiskSizeWithoutHeader, this.uncompressedSizeWithoutHeader, this.prevBlockOffset, this.buf, this.fillHeader, this.offset, this.nextBlockOnDiskSize, this.onDiskDataSizeWithHeader, this.fileContext, this.allocator);
    }
}

