/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile;

import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.BlockCache;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.FirstLevelBlockCache;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class InclusiveCombinedBlockCache
extends CombinedBlockCache {
    public InclusiveCombinedBlockCache(FirstLevelBlockCache l1, BlockCache l2) {
        super(l1, l2);
        l1.setVictimCache(l2);
    }

    @Override
    public Cacheable getBlock(BlockCacheKey cacheKey, boolean caching, boolean repeat, boolean updateCacheMetrics) {
        return this.l1Cache.getBlock(cacheKey, caching, repeat, updateCacheMetrics);
    }

    @Override
    public void cacheBlock(BlockCacheKey cacheKey, Cacheable buf, boolean inMemory) {
        this.l1Cache.cacheBlock(cacheKey, buf, inMemory);
        this.l2Cache.cacheBlock(cacheKey, buf, inMemory);
    }

    @Override
    public boolean evictBlock(BlockCacheKey cacheKey) {
        boolean l1Result = this.l1Cache.evictBlock(cacheKey);
        boolean l2Result = this.l2Cache.evictBlock(cacheKey);
        return l1Result || l2Result;
    }
}

