/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket.FileMmapIOEngine;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SharedMemoryMmapIOEngine
extends FileMmapIOEngine {
    public SharedMemoryMmapIOEngine(String filePath, long capacity) throws IOException {
        super(filePath, capacity);
    }

    @Override
    public boolean usesSharedMemory() {
        return true;
    }

    @Override
    public Cacheable read(BucketEntry be) throws IOException {
        ByteBuffer[] buffers = this.bufferArray.asSubByteBuffers(be.offset(), be.getLength());
        return be.wrapAsCacheable(buffers);
    }
}

