/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hadoop.hbase.master.MetricsAssignmentManagerSource;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import io.hops.hudi.org.apache.hadoop.hbase.metrics.OperationMetrics;
import io.hops.hudi.org.apache.hadoop.metrics2.MetricHistogram;
import io.hops.hudi.org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsAssignmentManagerSourceImpl
extends BaseSourceImpl
implements MetricsAssignmentManagerSource {
    private MutableGaugeLong ritGauge;
    private MutableGaugeLong ritCountOverThresholdGauge;
    private MutableGaugeLong ritOldestAgeGauge;
    private MetricHistogram ritDurationHisto;
    private MutableGaugeLong deadServerOpenRegions;
    private MutableGaugeLong unknownServerOpenRegions;
    private MutableGaugeLong orphanRegionsOnRsGauge;
    private MutableGaugeLong orphanRegionsOnFsGauge;
    private MutableGaugeLong inconsistentRegionsGauge;
    private MutableGaugeLong holesGauge;
    private MutableGaugeLong overlapsGauge;
    private MutableGaugeLong unknownServerRegionsGauge;
    private MutableGaugeLong emptyRegionInfoRegionsGauge;
    private MutableFastCounter operationCounter;
    private OperationMetrics assignMetrics;
    private OperationMetrics unassignMetrics;
    private OperationMetrics moveMetrics;
    private OperationMetrics reopenMetrics;
    private OperationMetrics openMetrics;
    private OperationMetrics closeMetrics;
    private OperationMetrics splitMetrics;
    private OperationMetrics mergeMetrics;

    public MetricsAssignmentManagerSourceImpl() {
        this("AssignmentManager", "Metrics about HBase master assignment manager.", "master", "Master,sub=AssignmentManager");
    }

    public MetricsAssignmentManagerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public void init() {
        this.ritGauge = this.metricsRegistry.newGauge("ritCount", "Current number of Regions In Transition (Gauge).", 0L);
        this.ritCountOverThresholdGauge = this.metricsRegistry.newGauge("ritCountOverThreshold", "Current number of Regions In Transition over threshold time (Gauge).", 0L);
        this.ritOldestAgeGauge = this.metricsRegistry.newGauge("ritOldestAge", "Timestamp in milliseconds of the oldest Region In Transition (Gauge).", 0L);
        this.ritDurationHisto = this.metricsRegistry.newTimeHistogram("ritDuration", "Total durations in milliseconds for all Regions in Transition (Histogram).");
        this.operationCounter = this.metricsRegistry.getCounter("operationCount", 0L);
        this.deadServerOpenRegions = this.metricsRegistry.newGauge("deadServerOpenRegions", "", 0L);
        this.unknownServerOpenRegions = this.metricsRegistry.newGauge("unknownServerOpenRegions", "", 0L);
        this.orphanRegionsOnRsGauge = this.metricsRegistry.newGauge("orphanRegionsOnRS", "Current number of Orphan Regions on RS (Gauge).", 0L);
        this.orphanRegionsOnFsGauge = this.metricsRegistry.newGauge("orphanRegionsOnFS", "Current number of Orphan Regions on FS (Gauge).", 0L);
        this.inconsistentRegionsGauge = this.metricsRegistry.newGauge("inconsistentRegions", "Current number of Inconsistent Regions (Gauge).", 0L);
        this.holesGauge = this.metricsRegistry.newGauge("holes", "Current number of Holes (Gauge).", 0L);
        this.overlapsGauge = this.metricsRegistry.newGauge("overlaps", "Current number of Overlaps (Gauge).", 0L);
        this.unknownServerRegionsGauge = this.metricsRegistry.newGauge("unknownServerRegions", "Current number of Unknown Server Regions (Gauge).", 0L);
        this.emptyRegionInfoRegionsGauge = this.metricsRegistry.newGauge("emptyRegionInfoRegions", "Current number of Regions with Empty Region Info (Gauge).", 0L);
        this.assignMetrics = new OperationMetrics(this.registry, "assign");
        this.unassignMetrics = new OperationMetrics(this.registry, "unassign");
        this.moveMetrics = new OperationMetrics(this.registry, "move");
        this.reopenMetrics = new OperationMetrics(this.registry, "reopen");
        this.openMetrics = new OperationMetrics(this.registry, "open");
        this.closeMetrics = new OperationMetrics(this.registry, "close");
        this.splitMetrics = new OperationMetrics(this.registry, "split");
        this.mergeMetrics = new OperationMetrics(this.registry, "merge");
    }

    @Override
    public void setRIT(int ritCount) {
        this.ritGauge.set((long)ritCount);
    }

    @Override
    public void setRITCountOverThreshold(int ritCount) {
        this.ritCountOverThresholdGauge.set((long)ritCount);
    }

    @Override
    public void setRITOldestAge(long ritCount) {
        this.ritOldestAgeGauge.set(ritCount);
    }

    @Override
    public void incrementOperationCounter() {
        this.operationCounter.incr();
    }

    @Override
    public void updateRitDuration(long duration) {
        this.ritDurationHisto.add(duration);
    }

    @Override
    public void updateDeadServerOpenRegions(int deadRegions) {
        this.deadServerOpenRegions.set((long)deadRegions);
    }

    @Override
    public void updateUnknownServerOpenRegions(int unknownRegions) {
        this.unknownServerOpenRegions.set((long)unknownRegions);
    }

    @Override
    public void setOrphanRegionsOnRs(int orphanRegionsOnRs) {
        this.orphanRegionsOnRsGauge.set((long)orphanRegionsOnRs);
    }

    @Override
    public void setOrphanRegionsOnFs(int orphanRegionsOnFs) {
        this.orphanRegionsOnFsGauge.set((long)orphanRegionsOnFs);
    }

    @Override
    public void setInconsistentRegions(int inconsistentRegions) {
        this.inconsistentRegionsGauge.set((long)inconsistentRegions);
    }

    @Override
    public void setHoles(int holes) {
        this.holesGauge.set((long)holes);
    }

    @Override
    public void setOverlaps(int overlaps) {
        this.overlapsGauge.set((long)overlaps);
    }

    @Override
    public void setUnknownServerRegions(int unknownServerRegions) {
        this.unknownServerRegionsGauge.set((long)unknownServerRegions);
    }

    @Override
    public void setEmptyRegionInfoRegions(int emptyRegionInfoRegions) {
        this.emptyRegionInfoRegionsGauge.set((long)emptyRegionInfoRegions);
    }

    @Override
    public OperationMetrics getAssignMetrics() {
        return this.assignMetrics;
    }

    @Override
    public OperationMetrics getUnassignMetrics() {
        return this.unassignMetrics;
    }

    @Override
    public OperationMetrics getSplitMetrics() {
        return this.splitMetrics;
    }

    @Override
    public OperationMetrics getMergeMetrics() {
        return this.mergeMetrics;
    }

    @Override
    public OperationMetrics getMoveMetrics() {
        return this.moveMetrics;
    }

    @Override
    public OperationMetrics getReopenMetrics() {
        return this.reopenMetrics;
    }

    @Override
    public OperationMetrics getOpenMetrics() {
        return this.openMetrics;
    }

    @Override
    public OperationMetrics getCloseMetrics() {
        return this.closeMetrics;
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder metricsRecordBuilder = metricsCollector.addRecord(this.metricsName);
        this.metricsRegistry.snapshot(metricsRecordBuilder, all);
        if (this.metricsAdapter != null) {
            this.metricsAdapter.snapshotAllMetrics(this.registry, metricsRecordBuilder);
        }
    }
}

