/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.balancer;

import io.hops.hudi.org.apache.hadoop.hbase.RegionMetrics;
import io.hops.hudi.org.apache.hadoop.hbase.Size;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class BalancerRegionLoad {
    private final long readRequestsCount;
    private final long writeRequestsCount;
    private final int memStoreSizeMB;
    private final int storefileSizeMB;

    BalancerRegionLoad(RegionMetrics regionMetrics) {
        this.readRequestsCount = regionMetrics.getReadRequestCount();
        this.writeRequestsCount = regionMetrics.getWriteRequestCount();
        this.memStoreSizeMB = (int)regionMetrics.getMemStoreSize().get(Size.Unit.MEGABYTE);
        this.storefileSizeMB = (int)regionMetrics.getStoreFileSize().get(Size.Unit.MEGABYTE);
    }

    public long getReadRequestsCount() {
        return this.readRequestsCount;
    }

    public long getWriteRequestsCount() {
        return this.writeRequestsCount;
    }

    public int getMemStoreSizeMB() {
        return this.memStoreSizeMB;
    }

    public int getStorefileSizeMB() {
        return this.storefileSizeMB;
    }
}

