/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.balancer;

import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.BaseLoadBalancer;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.CandidateGenerator;
import io.hops.hudi.org.apache.hadoop.hbase.master.balancer.StochasticLoadBalancer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class RegionReplicaCandidateGenerator
extends CandidateGenerator {
    StochasticLoadBalancer.RandomCandidateGenerator randomGenerator = new StochasticLoadBalancer.RandomCandidateGenerator();

    RegionReplicaCandidateGenerator() {
    }

    int selectCoHostedRegionPerGroup(int[] primariesOfRegionsPerGroup, int[] regionsPerGroup, int[] regionIndexToPrimaryIndex) {
        int currentPrimary = -1;
        int currentPrimaryIndex = -1;
        int selectedPrimaryIndex = -1;
        double currentLargestRandom = -1.0;
        for (int j = 0; j <= primariesOfRegionsPerGroup.length; ++j) {
            double currentRandom;
            int primary;
            int n = primary = j < primariesOfRegionsPerGroup.length ? primariesOfRegionsPerGroup[j] : -1;
            if (primary == currentPrimary) continue;
            int numReplicas = j - currentPrimaryIndex;
            if (numReplicas > 1 && (currentRandom = StochasticLoadBalancer.RANDOM.nextDouble()) > currentLargestRandom) {
                selectedPrimaryIndex = currentPrimary;
                currentLargestRandom = currentRandom;
            }
            currentPrimary = primary;
            currentPrimaryIndex = j;
        }
        for (int regionIndex : regionsPerGroup) {
            if (selectedPrimaryIndex != regionIndexToPrimaryIndex[regionIndex] || selectedPrimaryIndex == regionIndex) continue;
            return regionIndex;
        }
        return -1;
    }

    @Override
    BaseLoadBalancer.Cluster.Action generate(BaseLoadBalancer.Cluster cluster) {
        int serverIndex = this.pickRandomServer(cluster);
        if (cluster.numServers <= 1 || serverIndex == -1) {
            return BaseLoadBalancer.Cluster.NullAction;
        }
        int regionIndex = this.selectCoHostedRegionPerGroup(cluster.primariesOfRegionsPerServer[serverIndex], cluster.regionsPerServer[serverIndex], cluster.regionIndexToPrimaryIndex);
        if (regionIndex == -1) {
            return this.randomGenerator.generate(cluster);
        }
        int toServerIndex = this.pickOtherRandomServer(cluster, serverIndex);
        int toRegionIndex = this.pickRandomRegion(cluster, toServerIndex, 0.9f);
        return this.getAction(serverIndex, regionIndex, toServerIndex, toRegionIndex);
    }
}

