/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.SplitWALProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.SplitWALCallable;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import io.hops.hudi.org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALRemoteProcedure.class);
    private String walPath;
    private ServerName crashedServer;

    public SplitWALRemoteProcedure() {
    }

    public SplitWALRemoteProcedure(ServerName worker, ServerName crashedServer, String wal) {
        this.targetServer = worker;
        this.crashedServer = crashedServer;
        this.walPath = wal;
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SplitWALRemoteData.Builder builder = MasterProcedureProtos.SplitWALRemoteData.newBuilder();
        builder.setWalPath(this.walPath).setWorker(ProtobufUtil.toServerName(this.targetServer)).setCrashedServer(ProtobufUtil.toServerName(this.crashedServer));
        serializer.serialize((Message)builder.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SplitWALRemoteData data = (MasterProcedureProtos.SplitWALRemoteData)serializer.deserialize(MasterProcedureProtos.SplitWALRemoteData.class);
        this.walPath = data.getWalPath();
        this.targetServer = ProtobufUtil.toServerName(data.getWorker());
        this.crashedServer = ProtobufUtil.toServerName(data.getCrashedServer());
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv env, ServerName serverName) {
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SplitWALCallable.class, MasterProcedureProtos.SplitWALParameter.newBuilder().setWalPath(this.walPath).build().toByteArray()));
    }

    @Override
    protected void complete(MasterProcedureEnv env, Throwable error) {
        if (error == null) {
            try {
                env.getMasterServices().getSplitWALManager().archive(this.walPath);
            }
            catch (IOException e) {
                LOG.warn("Failed split of {}; ignore...", (Object)this.walPath, (Object)e);
            }
            this.succ = true;
        } else if (error instanceof DoNotRetryIOException) {
            LOG.warn("Sent {} to wrong server {}, try another", new Object[]{this.walPath, this.targetServer, error});
            this.succ = true;
        } else {
            LOG.warn("Failed split of {}, retry...", (Object)this.walPath, (Object)error);
            this.succ = false;
        }
    }

    public String getWAL() {
        return this.walPath;
    }

    @Override
    public ServerName getServerName() {
        return this.crashedServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return AbstractFSWALProvider.isMetaFile(new Path(this.walPath));
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SPLIT_WAL_REMOTE;
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getProcName());
        if (this.targetServer != null) {
            builder.append(", worker=");
            builder.append(this.targetServer);
        }
    }

    public String getProcName() {
        return this.getClass().getSimpleName() + " " + SplitWALProcedure.getWALNameFromStrPath(this.getWAL());
    }
}

