/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerRemoteProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.RemoteProcedureDispatcher;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.SwitchRpcThrottleRemoteCallable;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import java.io.IOException;
import java.util.Optional;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SwitchRpcThrottleRemoteProcedure
extends ServerRemoteProcedure
implements ServerProcedureInterface {
    private static final Logger LOG = LoggerFactory.getLogger(SwitchRpcThrottleRemoteProcedure.class);
    private boolean rpcThrottleEnabled;

    public SwitchRpcThrottleRemoteProcedure() {
    }

    public SwitchRpcThrottleRemoteProcedure(ServerName serverName, boolean rpcThrottleEnabled) {
        this.targetServer = serverName;
        this.rpcThrottleEnabled = rpcThrottleEnabled;
    }

    protected void rollback(MasterProcedureEnv env) throws IOException, InterruptedException {
    }

    protected boolean abort(MasterProcedureEnv env) {
        return false;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.newBuilder().setTargetServer(ProtobufUtil.toServerName(this.targetServer)).setRpcThrottleEnabled(this.rpcThrottleEnabled).build();
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        MasterProcedureProtos.SwitchRpcThrottleRemoteStateData data = (MasterProcedureProtos.SwitchRpcThrottleRemoteStateData)serializer.deserialize(MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.class);
        this.targetServer = ProtobufUtil.toServerName(data.getTargetServer());
        this.rpcThrottleEnabled = data.getRpcThrottleEnabled();
    }

    public Optional<RemoteProcedureDispatcher.RemoteOperation> remoteCallBuild(MasterProcedureEnv masterProcedureEnv, ServerName remote) {
        assert (this.targetServer.equals(remote));
        return Optional.of(new RSProcedureDispatcher.ServerOperation(this, this.getProcId(), SwitchRpcThrottleRemoteCallable.class, MasterProcedureProtos.SwitchRpcThrottleRemoteStateData.newBuilder().setTargetServer(ProtobufUtil.toServerName(remote)).setRpcThrottleEnabled(this.rpcThrottleEnabled).build().toByteArray()));
    }

    @Override
    public ServerName getServerName() {
        return this.targetServer;
    }

    @Override
    public boolean hasMetaTableRegion() {
        return false;
    }

    @Override
    public ServerProcedureInterface.ServerOperationType getServerOperationType() {
        return ServerProcedureInterface.ServerOperationType.SWITCH_RPC_THROTTLE;
    }

    @Override
    protected void complete(MasterProcedureEnv env, Throwable error) {
        if (error != null) {
            LOG.warn("Failed to switch rpc throttle to {} on server {}", new Object[]{this.rpcThrottleEnabled, this.targetServer, error});
            this.succ = false;
        } else {
            this.succ = true;
        }
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" server=");
        sb.append(this.targetServer);
        sb.append(", rpcThrottleEnabled=");
        sb.append(this.rpcThrottleEnabled);
    }
}

