/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.namespace;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NamespaceTableAndRegionInfo {
    private String name;
    private Map<TableName, AtomicInteger> tableAndRegionInfo;

    public NamespaceTableAndRegionInfo(String namespace) {
        this.name = namespace;
        this.tableAndRegionInfo = new HashMap<TableName, AtomicInteger>();
    }

    String getName() {
        return this.name;
    }

    synchronized Set<TableName> getTables() {
        return this.tableAndRegionInfo.keySet();
    }

    synchronized int getRegionCount() {
        int regionCount = 0;
        for (Map.Entry<TableName, AtomicInteger> entry : this.tableAndRegionInfo.entrySet()) {
            regionCount += entry.getValue().get();
        }
        return regionCount;
    }

    synchronized int getRegionCountOfTable(TableName tableName) {
        if (this.tableAndRegionInfo.containsKey(tableName)) {
            return this.tableAndRegionInfo.get(tableName).get();
        }
        return -1;
    }

    synchronized boolean containsTable(TableName tableName) {
        return this.tableAndRegionInfo.containsKey(tableName);
    }

    synchronized void addTable(TableName tableName, int regionCount) {
        if (!this.name.equalsIgnoreCase(tableName.getNamespaceAsString())) {
            throw new IllegalStateException("Table : " + tableName + " does not belong to namespace " + this.name);
        }
        if (this.tableAndRegionInfo.containsKey(tableName)) {
            throw new IllegalStateException("Table already in the cache " + tableName);
        }
        this.tableAndRegionInfo.put(tableName, new AtomicInteger(regionCount));
    }

    synchronized void removeTable(TableName tableName) {
        this.tableAndRegionInfo.remove(tableName);
    }

    synchronized int incRegionCountForTable(TableName tableName, int count) {
        return this.tableAndRegionInfo.get(tableName).addAndGet(count);
    }

    synchronized int decrementRegionCountForTable(TableName tableName, int count) {
        return this.tableAndRegionInfo.get(tableName).decrementAndGet();
    }

    public String toString() {
        Joiner.MapJoiner mapJoiner = Joiner.on(',').withKeyValueSeparator("=");
        return "NamespaceTableAndRegionInfo [name=" + this.name + ", tableAndRegionInfo=" + mapJoiner.join(this.tableAndRegionInfo) + "]";
    }
}

