/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hadoop.hbase.quotas.RateLimiter;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class FixedIntervalRateLimiter
extends RateLimiter {
    private long nextRefillTime = -1L;

    @Override
    public long refill(long limit) {
        long now = EnvironmentEdgeManager.currentTime();
        if (now < this.nextRefillTime) {
            return 0L;
        }
        this.nextRefillTime = now + super.getTimeUnitInMillis();
        return limit;
    }

    @Override
    public long getWaitInterval(long limit, long available, long amount) {
        if (this.nextRefillTime == -1L) {
            return 0L;
        }
        long now = EnvironmentEdgeManager.currentTime();
        long refillTime = this.nextRefillTime;
        return refillTime - now;
    }

    @Override
    public void setNextRefillTime(long nextRefillTime) {
        this.nextRefillTime = nextRefillTime;
    }

    @Override
    public long getNextRefillTime() {
        return this.nextRefillTime;
    }
}

