/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcScheduler;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.DefaultOperationQuota;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.ExceedOperationQuota;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.NoopOperationQuota;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.OperationQuota;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaCache;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.RpcThrottleStorage;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.UserQuotaState;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.Region;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionServerServices;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class RegionServerRpcQuotaManager {
    private static final Logger LOG = LoggerFactory.getLogger(RegionServerRpcQuotaManager.class);
    private final RegionServerServices rsServices;
    private QuotaCache quotaCache = null;
    private volatile boolean rpcThrottleEnabled;
    private RpcThrottleStorage rpcThrottleStorage;

    public RegionServerRpcQuotaManager(RegionServerServices rsServices) {
        this.rsServices = rsServices;
        this.rpcThrottleStorage = new RpcThrottleStorage(rsServices.getZooKeeper(), rsServices.getConfiguration());
    }

    public void start(RpcScheduler rpcScheduler) throws IOException {
        if (!QuotaUtil.isQuotaEnabled(this.rsServices.getConfiguration())) {
            LOG.info("Quota support disabled");
            return;
        }
        LOG.info("Initializing RPC quota support");
        this.quotaCache = new QuotaCache(this.rsServices);
        this.quotaCache.start();
        this.rpcThrottleEnabled = this.rpcThrottleStorage.isRpcThrottleEnabled();
        LOG.info("Start rpc quota manager and rpc throttle enabled is {}", (Object)this.rpcThrottleEnabled);
    }

    public void stop() {
        if (this.isQuotaEnabled()) {
            this.quotaCache.stop("shutdown");
        }
    }

    protected boolean isRpcThrottleEnabled() {
        return this.rpcThrottleEnabled;
    }

    private boolean isQuotaEnabled() {
        return this.quotaCache != null;
    }

    public void switchRpcThrottle(boolean enable) throws IOException {
        if (this.isQuotaEnabled()) {
            if (this.rpcThrottleEnabled != enable) {
                boolean previousEnabled = this.rpcThrottleEnabled;
                this.rpcThrottleEnabled = this.rpcThrottleStorage.isRpcThrottleEnabled();
                LOG.info("Switch rpc throttle from {} to {}", (Object)previousEnabled, (Object)this.rpcThrottleEnabled);
            } else {
                LOG.warn("Skip switch rpc throttle because previous value {} is the same as current value {}", (Object)this.rpcThrottleEnabled, (Object)enable);
            }
        } else {
            LOG.warn("Skip switch rpc throttle to {} because rpc quota is disabled", (Object)enable);
        }
    }

    QuotaCache getQuotaCache() {
        return this.quotaCache;
    }

    public OperationQuota getQuota(UserGroupInformation ugi, TableName table) {
        if (this.isQuotaEnabled() && !table.isSystemTable() && this.isRpcThrottleEnabled()) {
            UserQuotaState userQuotaState = this.quotaCache.getUserQuotaState(ugi);
            QuotaLimiter userLimiter = userQuotaState.getTableLimiter(table);
            boolean useNoop = userLimiter.isBypass();
            if (userQuotaState.hasBypassGlobals()) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter);
                }
                if (!useNoop) {
                    return new DefaultOperationQuota(this.rsServices.getConfiguration(), userLimiter);
                }
            } else {
                QuotaLimiter nsLimiter = this.quotaCache.getNamespaceLimiter(table.getNamespaceAsString());
                QuotaLimiter tableLimiter = this.quotaCache.getTableLimiter(table);
                QuotaLimiter rsLimiter = this.quotaCache.getRegionServerQuotaLimiter("all");
                useNoop &= tableLimiter.isBypass() && nsLimiter.isBypass() && rsLimiter.isBypass();
                boolean exceedThrottleQuotaEnabled = this.quotaCache.isExceedThrottleQuotaEnabled();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("get quota for ugi=" + ugi + " table=" + table + " userLimiter=" + userLimiter + " tableLimiter=" + tableLimiter + " nsLimiter=" + nsLimiter + " rsLimiter=" + rsLimiter + " exceedThrottleQuotaEnabled=" + exceedThrottleQuotaEnabled);
                }
                if (!useNoop) {
                    if (exceedThrottleQuotaEnabled) {
                        return new ExceedOperationQuota(this.rsServices.getConfiguration(), rsLimiter, new QuotaLimiter[]{userLimiter, tableLimiter, nsLimiter});
                    }
                    return new DefaultOperationQuota(this.rsServices.getConfiguration(), userLimiter, tableLimiter, nsLimiter, rsLimiter);
                }
            }
        }
        return NoopOperationQuota.get();
    }

    public OperationQuota checkQuota(Region region, OperationQuota.OperationType type) throws IOException, RpcThrottlingException {
        switch (type) {
            case SCAN: {
                return this.checkQuota(region, 0, 0, 1);
            }
            case GET: {
                return this.checkQuota(region, 0, 1, 0);
            }
            case MUTATE: {
                return this.checkQuota(region, 1, 0, 0);
            }
        }
        throw new RuntimeException("Invalid operation type: " + (Object)((Object)type));
    }

    public OperationQuota checkQuota(Region region, List<ClientProtos.Action> actions) throws IOException, RpcThrottlingException {
        int numWrites = 0;
        int numReads = 0;
        for (ClientProtos.Action action : actions) {
            if (action.hasMutation()) {
                ++numWrites;
                continue;
            }
            if (!action.hasGet()) continue;
            ++numReads;
        }
        return this.checkQuota(region, numWrites, numReads, 0);
    }

    private OperationQuota checkQuota(Region region, int numWrites, int numReads, int numScans) throws IOException, RpcThrottlingException {
        Optional<User> user = RpcServer.getRequestUser();
        UserGroupInformation ugi = user.isPresent() ? user.get().getUGI() : User.getCurrent().getUGI();
        TableName table = region.getTableDescriptor().getTableName();
        OperationQuota quota = this.getQuota(ugi, table);
        try {
            quota.checkQuota(numWrites, numReads, numScans);
        }
        catch (RpcThrottlingException e) {
            LOG.debug("Throttling exception for user=" + ugi.getUserName() + " table=" + table + " numWrites=" + numWrites + " numReads=" + numReads + " numScans=" + numScans + ": " + e.getMessage());
            throw e;
        }
        return quota;
    }
}

