/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.RegionSplitRestriction;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class DelimitedKeyPrefixRegionSplitRestriction
extends RegionSplitRestriction {
    private static final Logger LOG = LoggerFactory.getLogger(DelimitedKeyPrefixRegionSplitRestriction.class);
    public static final String DELIMITER_KEY = "hbase.regionserver.region.split_restriction.delimiter";
    private byte[] delimiter = null;

    @Override
    public void initialize(TableDescriptor tableDescriptor, Configuration conf) throws IOException {
        String delimiterString = tableDescriptor.getValue(DELIMITER_KEY);
        if (!(delimiterString != null && delimiterString.length() != 0 || (delimiterString = conf.get(DELIMITER_KEY)) != null && delimiterString.length() != 0)) {
            LOG.error("{} not specified for table {}. Using the default RegionSplitRestriction", (Object)DELIMITER_KEY, (Object)tableDescriptor.getTableName());
            return;
        }
        this.delimiter = Bytes.toBytes(delimiterString);
    }

    @Override
    public byte[] getRestrictedSplitPoint(byte[] splitPoint) {
        if (this.delimiter != null) {
            int index = io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.primitives.Bytes.indexOf(splitPoint, this.delimiter);
            if (index < 0) {
                LOG.warn("Delimiter {} not found for split key {}", (Object)Bytes.toString(this.delimiter), (Object)Bytes.toStringBinary(splitPoint));
                return splitPoint;
            }
            return Arrays.copyOf(splitPoint, Math.min(index, splitPoint.length));
        }
        return splitPoint;
    }
}

