/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionSource;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionWrapper;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserAggregateFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsRegion {
    private final MetricsRegionSource source;
    private final MetricsUserAggregate userAggregate;
    private MetricsRegionWrapper regionWrapper;

    public MetricsRegion(MetricsRegionWrapper wrapper, Configuration conf) {
        this.source = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).createRegion(wrapper);
        this.regionWrapper = wrapper;
        this.userAggregate = MetricsUserAggregateFactory.getMetricsUserAggregate(conf);
    }

    public void close() {
        this.source.close();
    }

    public void updatePut() {
        this.source.updatePut();
    }

    public void updateDelete() {
        this.source.updateDelete();
    }

    public void updateGet(long t) {
        this.source.updateGet(t);
    }

    public void updateScanTime(long t) {
        this.source.updateScanTime(t);
    }

    public void updateFilteredRecords() {
        this.userAggregate.updateFilteredReadRequests();
    }

    public void updateAppend() {
        this.source.updateAppend();
    }

    public void updateIncrement() {
        this.source.updateIncrement();
    }

    MetricsRegionSource getSource() {
        return this.source;
    }

    public MetricsRegionWrapper getRegionWrapper() {
        return this.regionWrapper;
    }

    public void updateReadRequestCount() {
        this.userAggregate.updateReadRequestCount();
    }
}

