/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.RpcServer;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserAggregate;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.security.UserProvider;
import io.hops.hudi.org.apache.hadoop.hbase.util.LossyCounting;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsUserAggregateImpl
implements MetricsUserAggregate {
    private final UserProvider userProvider;
    private final MetricsUserAggregateSource source = CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class).getUserAggregate();
    private final LossyCounting<MetricsUserSource> userMetricLossyCounting;

    public MetricsUserAggregateImpl(Configuration conf) {
        this.userMetricLossyCounting = new LossyCounting<MetricsUserSource>("userMetrics", conf, this.source::deregister);
        this.userProvider = UserProvider.instantiate(conf);
    }

    private String getActiveUser() {
        Optional<User> user = RpcServer.getRequestUser();
        if (!user.isPresent()) {
            try {
                user = Optional.of(this.userProvider.getCurrent());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return user.map(User::getShortName).orElse(null);
    }

    @Override
    public MetricsUserAggregateSource getSource() {
        return this.source;
    }

    @Override
    public void updatePut(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updatePut(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    private String getClient() {
        Optional<InetAddress> ipOptional = RpcServer.getRemoteAddress();
        return ipOptional.map(InetAddress::getHostName).orElse(null);
    }

    private void incrementClientReadMetrics(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementReadRequest();
        }
    }

    private void incrementFilteredReadRequests(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementFilteredReadRequests();
        }
    }

    private void incrementClientWriteMetrics(MetricsUserSource userSource) {
        String client = this.getClient();
        if (client != null && userSource != null) {
            userSource.getOrCreateMetricsClient(client).incrementWriteRequest();
        }
    }

    @Override
    public void updateDelete(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateDelete(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateGet(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateGet(t);
        }
    }

    @Override
    public void updateIncrement(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateIncrement(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateAppend(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateAppend(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateReplay(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateReplay(t);
            this.incrementClientWriteMetrics(userSource);
        }
    }

    @Override
    public void updateScanTime(long t) {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            userSource.updateScanTime(t);
        }
    }

    @Override
    public void updateFilteredReadRequests() {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            this.incrementFilteredReadRequests(userSource);
        }
    }

    @Override
    public void updateReadRequestCount() {
        String user = this.getActiveUser();
        if (user != null) {
            MetricsUserSource userSource = this.getOrCreateMetricsUser(user);
            this.incrementClientReadMetrics(userSource);
        }
    }

    private MetricsUserSource getOrCreateMetricsUser(String user) {
        MetricsUserSource userSource = this.source.getOrCreateMetricsUser(user);
        this.userMetricLossyCounting.add(userSource);
        return userSource;
    }
}

