/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserAggregateSource;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserSource;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MetricsUserSourceImpl;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MetricsUserAggregateSourceImpl
extends BaseSourceImpl
implements MetricsUserAggregateSource {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsUserAggregateSourceImpl.class);
    private final ConcurrentHashMap<String, MetricsUserSource> userSources = new ConcurrentHashMap();

    public MetricsUserAggregateSourceImpl() {
        this("Users", "Metrics about users connected to the regionserver", "regionserver", "RegionServer,sub=Users");
    }

    public MetricsUserAggregateSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
    }

    @Override
    public MetricsUserSource getOrCreateMetricsUser(String user) {
        MetricsUserSource source = this.userSources.get(user);
        if (source != null) {
            return source;
        }
        source = new MetricsUserSourceImpl(user, this);
        MetricsUserSource prev = this.userSources.putIfAbsent(user, source);
        if (prev != null) {
            return prev;
        }
        this.register(source);
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(MetricsUserSource source) {
        MetricsUserAggregateSourceImpl metricsUserAggregateSourceImpl = this;
        synchronized (metricsUserAggregateSourceImpl) {
            source.register();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister(MetricsUserSource toRemove) {
        try {
            MetricsUserAggregateSourceImpl metricsUserAggregateSourceImpl = this;
            synchronized (metricsUserAggregateSourceImpl) {
                MetricsUserSource source = this.userSources.remove(toRemove.getUser());
                if (source != null) {
                    source.deregister();
                }
            }
        }
        catch (Exception e) {
            LOG.info("Error trying to remove " + toRemove + " from " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    @Override
    public Map<String, MetricsUserSource> getUserSources() {
        return Collections.unmodifiableMap(this.userSources);
    }

    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder mrb = collector.addRecord(this.metricsName);
        if (this.userSources != null) {
            for (MetricsUserSource userMetricSource : this.userSources.values()) {
                if (!(userMetricSource instanceof MetricsUserSourceImpl)) continue;
                ((MetricsUserSourceImpl)userMetricSource).snapshot(mrb, all);
            }
            mrb.addGauge(Interns.info((String)"numUsers", (String)"Number of users in the metrics system"), this.userSources.size());
            this.metricsRegistry.snapshot(mrb, all);
        }
    }
}

