/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.FlushType;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import java.lang.management.MemoryType;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.LongAdder;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class RegionServerAccounting {
    private final LongAdder globalMemStoreDataSize = new LongAdder();
    private final LongAdder globalMemStoreHeapSize = new LongAdder();
    private final LongAdder globalMemStoreOffHeapSize = new LongAdder();
    private long globalMemStoreLimit;
    private final float globalMemStoreLimitLowMarkPercent;
    private long globalMemStoreLimitLowMark;
    private final MemoryType memType;
    private long globalOnHeapMemstoreLimit;
    private long globalOnHeapMemstoreLimitLowMark;
    private ConcurrentMap<String, Pair<Long, Long>> retainedRegionRWRequestsCnt;

    public RegionServerAccounting(Configuration conf) {
        Pair<Long, MemoryType> globalMemstoreSizePair = MemorySizeUtil.getGlobalMemStoreSize(conf);
        this.globalMemStoreLimit = globalMemstoreSizePair.getFirst();
        this.memType = globalMemstoreSizePair.getSecond();
        this.globalMemStoreLimitLowMarkPercent = MemorySizeUtil.getGlobalMemStoreHeapLowerMark(conf, this.memType == MemoryType.HEAP);
        this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        this.globalOnHeapMemstoreLimit = MemorySizeUtil.getOnheapGlobalMemStoreSize(conf);
        this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
        this.retainedRegionRWRequestsCnt = new ConcurrentHashMap<String, Pair<Long, Long>>();
    }

    long getGlobalMemStoreLimit() {
        return this.globalMemStoreLimit;
    }

    long getGlobalOnHeapMemStoreLimit() {
        return this.globalOnHeapMemstoreLimit;
    }

    void setGlobalMemStoreLimits(long newGlobalMemstoreLimit) {
        if (this.memType == MemoryType.HEAP) {
            this.globalMemStoreLimit = newGlobalMemstoreLimit;
            this.globalMemStoreLimitLowMark = (long)((float)this.globalMemStoreLimit * this.globalMemStoreLimitLowMarkPercent);
        } else {
            this.globalOnHeapMemstoreLimit = newGlobalMemstoreLimit;
            this.globalOnHeapMemstoreLimitLowMark = (long)((float)this.globalOnHeapMemstoreLimit * this.globalMemStoreLimitLowMarkPercent);
        }
    }

    boolean isOffheap() {
        return this.memType == MemoryType.NON_HEAP;
    }

    long getGlobalMemStoreLimitLowMark() {
        return this.globalMemStoreLimitLowMark;
    }

    float getGlobalMemStoreLimitLowMarkPercent() {
        return this.globalMemStoreLimitLowMarkPercent;
    }

    public long getGlobalMemStoreDataSize() {
        return this.globalMemStoreDataSize.sum();
    }

    public long getGlobalMemStoreHeapSize() {
        return this.globalMemStoreHeapSize.sum();
    }

    public long getGlobalMemStoreOffHeapSize() {
        return this.globalMemStoreOffHeapSize.sum();
    }

    protected ConcurrentMap<String, Pair<Long, Long>> getRetainedRegionRWRequestsCnt() {
        return this.retainedRegionRWRequestsCnt;
    }

    void incGlobalMemStoreSize(MemStoreSize mss) {
        this.incGlobalMemStoreSize(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize());
    }

    public void incGlobalMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta) {
        this.globalMemStoreDataSize.add(dataSizeDelta);
        this.globalMemStoreHeapSize.add(heapSizeDelta);
        this.globalMemStoreOffHeapSize.add(offHeapSizeDelta);
    }

    public void decGlobalMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta) {
        this.globalMemStoreDataSize.add(-dataSizeDelta);
        this.globalMemStoreHeapSize.add(-heapSizeDelta);
        this.globalMemStoreOffHeapSize.add(-offHeapSizeDelta);
    }

    public FlushType isAboveHighWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemStoreHeapSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        } else {
            if (this.getGlobalMemStoreOffHeapSize() >= this.globalMemStoreLimit) {
                return FlushType.ABOVE_OFFHEAP_HIGHER_MARK;
            }
            if (this.getGlobalMemStoreHeapSize() >= this.globalOnHeapMemstoreLimit) {
                return FlushType.ABOVE_ONHEAP_HIGHER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public FlushType isAboveLowWaterMark() {
        if (this.memType == MemoryType.HEAP) {
            if (this.getGlobalMemStoreHeapSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        } else {
            if (this.getGlobalMemStoreOffHeapSize() >= this.globalMemStoreLimitLowMark) {
                return FlushType.ABOVE_OFFHEAP_LOWER_MARK;
            }
            if (this.getGlobalMemStoreHeapSize() >= this.globalOnHeapMemstoreLimitLowMark) {
                return FlushType.ABOVE_ONHEAP_LOWER_MARK;
            }
        }
        return FlushType.NORMAL;
    }

    public double getFlushPressure() {
        if (this.memType == MemoryType.HEAP) {
            return (double)this.getGlobalMemStoreHeapSize() * 1.0 / (double)this.globalMemStoreLimitLowMark;
        }
        return Math.max((double)this.getGlobalMemStoreOffHeapSize() * 1.0 / (double)this.globalMemStoreLimitLowMark, (double)this.getGlobalMemStoreHeapSize() * 1.0 / (double)this.globalOnHeapMemstoreLimitLowMark);
    }
}

